#include "mbed.h"
#include "EthernetInterface.h"
#include "Servo.h"
#include <string.h>

#define POS_CENTRO 1750
#define POS_MAX (POS_CENTRO + 110)
#define POS_MIN (POS_CENTRO - 110)
#define DIST_MIN 10
#define DIST_MAX 56
#define RESOL 1
#define PERIODO 10

const int ECHO_SERVER_PORT = 1234;
const int BROADCAST_PORT = 58083;

bool conectado = false;

int  setpoint;

Thread tcp_server;
Thread broadcast;
EthernetInterface eth;

Mutex m_dist;
Mutex m_ref;

unsigned int dist;
Servo Servo1(D6);

void tcp_server_thread ();
void udp_broadcast ();


int main (void)
{
    //inicializa o módulo ethernet
    eth.init();
    eth.connect();

    Servo1.Enable(POS_CENTRO,20000);
    // inicializa threads
    tcp_server.start(tcp_server_thread);
    broadcast.start(udp_broadcast);
    //controle.start(controle_thread);

    broadcast.join();
    printf("Todas as thread iniciadas\n");

    while (true) {

    }
}

void tcp_server_thread ()
{
    printf("\nServer IP Address is %s\n", eth.getIPAddress());

    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();

    printf("\nWait for new connection...\n");
    TCPSocketConnection client;
    server.accept(client);
    client.set_blocking(false, 1500); // Timeout after (1.5)s

    conectado = true;
    printf("\nConnection from: %s\n", client.get_address());
    char buffer[256];
    while (true) {
        int n = client.receive(buffer, sizeof(buffer));

        if (n <=1) {
            //printf("Waiting messenger...");
            //break;
        } else {

            // print received message to terminal
            buffer[n] = '\0';
            printf("Received message from Client :'%s'\n",buffer);

            int pos =  buffer[8] - '0';

            if(pos == 1)setpoint = 20;
            else if(pos == 2)setpoint = 35;
            else if(pos == 3)setpoint = 50;
            printf("Setpoint: %d\n", setpoint);

            m_ref.lock();
            // ref = atof(buffer);
            sprintf (buffer, "%s", client.get_address());
            m_ref.unlock();

            m_ref.lock();
            sprintf (buffer, "%s", client.get_address());
            m_ref.unlock();

            // print sending message to terminal
            printf("Sending message to Client: '%s'\n",buffer);

            // Echo received message back to client
            //client.send_all(buffer, n);
            // if (n <= 0) break;
            memset(buffer,0,256);
            
            if(buffer[0] == 'd') {
                for(int pos = 1000; pos < 2000; pos +=25) {
                    Servo1.SetPosition(pos);
                }
            } else if(buffer[0] == 'e') {
                for(int pos = 2000; pos > 1000; pos -=25) {
                    Servo1.SetPosition(pos);
                }
            }

        }
    }

    client.close();
}

void udp_broadcast ()
{
    UDPSocket sock;
    sock.init();
    sock.set_broadcasting();

    Endpoint broadcast;
    broadcast.set_address("255.255.255.255", BROADCAST_PORT);

    char out_buffer[] = "Coppeti";

    while (!conectado) {
        printf("Broadcasting...\n");
        sock.sendTo(broadcast, out_buffer, sizeof(out_buffer));
        Thread::wait(1000);
    }
    printf("Broadcast finalizado!\n");
}