#include "mbed.h"
#include "SDFileSystem.h"
//#include <string>

//Pines de conversión A/D asociados a los ejes del acelerómetro triaxial MMA7361L
AnalogIn ain_x(PTB0);
AnalogIn ain_y(PTB1);
AnalogIn ain_z(PTB2);
//Pines digitales para configurar el acelerómetro triaxial MMA7361L
DigitalOut slp(PTB3);
DigitalOut g_sel(PTC2);
//Cronómetro
Timer reloj;
//SD FAT system
SDFileSystem sd(PTD2, PTD3, PTD1, PTD0,"sd");
//Comunicación Xbee
Serial xbee(PTA2,PTA1); //Serial xbee(USBTX,USBRX);
//Pin de control de flujo RTS (usado en la función Serial_RTS)
DigitalIn rts(PTD4);


//Definición de variables globales
FILE * fp1;
FILE * fp2;
int inicio = 0;
int fin = 0;
int samples = 1;
int imax = 0;
char read [64] = {0};
char readvar [512] = {0};


//Declaración de la función UART con control de flujo
//Sólo RTS
int Serial_RTS(const char *str);


int main()
{
    //xbee.baud(9600);
    xbee.baud(115200);
    reloj.start();
    slp = 1;    //Habilitado el modo de operación normal (MMA7361L)
    g_sel = 0;  //Ajusta la sensibilidad a 1.5g (cambiar a 1 para ajustar sensibilidad a 6g)

    while(1) {
        xbee.scanf("%s",read); //Espera la recepción de caracteres
        switch(read[0]) {
            case 'r':   //Lee la información de la memoria SD y la envía mediante Xbee
                //if(read[1]=='1') { //Nombre para modulo 1...
                    fp2 = fopen ("/sd/test.txt","r");
                    
                    if(samples%42==0 && samples>42) imax=samples/42;
                    else imax=samples/42;
                    //imax=samples/42;
                    
                    for (int i=0; i<imax; i++) {
                        fscanf (fp2,"%s",readvar);
                        //xbee.printf("%s",readvar);
                        Serial_RTS(readvar);
                        xbee.putc('\n');
                    }
                    fclose (fp2);
                //}
                break;
            case 't':   //Envía el tiempo de adquisición
                //if(read[1]=='1') //Nombre para modulo 1...
                xbee.printf("%010d\n",fin-inicio); 
                break;
            default:    //Inicia la conversión A/D y la almacena en la memoria SD
                samples = atoi(read);
                //Inicio del reloj para determinar la tasa de muestreo
                fp1 = fopen ("/sd/test.txt","w");
                reloj.reset();
                inicio = reloj.read_us();
                //Ciclo de lectura de los ejes x, y, z del acelerómetro triaxial MMA7361L
                for(int i=1; i<=samples; i++) {
                    fprintf (fp1,"%04X%04X%04X",ain_x.read_u16(),ain_y.read_u16(),ain_z.read_u16());
                    if((i>=42) && (i%42==0)) fprintf (fp1,"\n");
                }
                //Tiempo transcurrido desde la ejecución del reloj
                fin = reloj.read_us();
                fclose (fp1);
                break;
        }
    }
}


//Definición de la función UART RTS
int Serial_RTS(const char *str)
{
    while (*str) {
        while(rts);
        xbee.putc(*str ++);
    }
    return 0;
}