#include "mbed.h"
#include "C12832.h"

InterruptIn  btn(p14);

Timer T1;

BusOut Leds (LED1, LED2, LED3, LED4);

C12832 lcd(p5, p7, p6, p8, p11); 

enum State {ST_EIN=0, ST_AUS, ST_ENDE};
State state;

int LedWert = 3, btnCount = 0;

bool pressed = false;

void rise(void)
{  
    wait_ms(50);
    pressed = true;
}

bool CheckFlag() 
{
    if (pressed) {
        pressed=false;
        return true;
        }
    return false;
}

void ST_Ein (void)
{
    //Status auf LCD und Serielle
    lcd.cls();      // löscht LCD (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 1 (Ein)");
    printf("State: 1 (Ein)");
    // entry
    
    // do
    while(true) {
        Leds = LedWert;
    
        if(CheckFlag()) {
            btnCount++;
            if(btnCount >= 3){
                btnCount = 0;
                LedWert++;
                state = ST_AUS;
            
    // exit
                return;
            }
        }
    }
}

void ST_Aus (void)
{
    //Status auf LCD und Serielle
    lcd.cls();      // löscht LCD (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: 2 (Aus)");
    printf("State: 2 (Aus)");
    
    // entry
    
    // do
    while(true) {
        Leds = 0;
    
        if(CheckFlag()) {
            T1.reset();
            T1.start();
             while(1){
                 
                 if(T1.read() >= 0.2) {
                        
                        break;                        
                     }
                 
                 else if(CheckFlag()){
                     T1.stop();
                     state = ST_ENDE;
                     return;
                     }
             }
             
            state = ST_EIN;
            
    // exit
            T1.stop();
            return;
            }
        }
}

void ST_Ende (void)
{
    //Status auf LCD und Serielle
    lcd.cls();      // löscht LCD (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: Ende");
    printf("State: Ende");
    wait_ms(300);
    return;
}

void ST_Error (void)
{
    //Status auf LCD und Serielle
    lcd.cls();      // löscht LCD (clear screen)
    lcd.locate(0,0);   // x-position, y-position (x: 0-128; y: 0-32)
    lcd.printf("State: Error");
    printf("State: Error");
    return;
}

void stateMachine()
{
    switch (state)
    {
    case ST_EIN: ST_Ein();
        break;
    case ST_AUS: ST_Aus();
        break;
    case ST_ENDE: ST_Ende();
        break;
    default: ST_Error();  
        break;
    }
}


 
int main()
{
    btn.rise(&rise);      
    
    Leds = 15;
    wait_ms(500);
    
    state = ST_EIN;
    while(true){
        stateMachine(); 
        }
}