//Mark Schwarzer    
//OCE 360 Assignment 8 

#include "mbed.h"
#include "GPSINT.h"
#include "SDFileSystem.h"

Serial pc(USBTX, USBRX);
GPSINT gps(p13, p14);
DigitalOut led1(LED1);

SDFileSystem sd(p5, p6, p7, p8, "sd");
Ticker log_ticker;
FILE *fp;
char file_name[100];

void log_data()  {
    fp= fopen(file_name, "a");
    fprintf(fp, "$GPS, 1, 6, %d,%f,%f,%f,%f,%f;\r\n", gps.lock, gps.utc_time, gps.dec_longitude, gps.dec_latitude, gps.speed_k, gps.course_d);
    fclose(fp);
    }
    
int main()  {
    mkdir("/sd/mydir", 0777);
    pc.printf("Please set a file name\r\n");
    sprintf(file_name, "/sd/mydir/%s.txt", "GPSlog_Schwarzer");
    pc.printf("The file name and directory is: %s\r\n", file_name);
    fp= fopen(file_name, "a");
    pc.printf("file_opened \n");
    
    if(fp== NULL)  {
        error("Could not open file for write\n");
        }
        fclose(fp);
        log_ticker.attach(&log_data, 1.0);
    
    while(1)  {
        if(gps.status== 'A') {
            led1=!led1;
            gps.dec_latitude=gps.nmea_to_dec(gps.nmea_latitude, gps.ns);  //conversions
            gps.dec_longitude=gps.nmea_to_dec(gps.nmea_longitude, gps.ew); //conversions
            pc.printf("$GPS, 1, 6, %d,%f,%f,%f,%f,%f;\r\n", gps.lock, gps.utc_time, gps.dec_longitude, gps.dec_latitude, gps.speed_k, gps.course_d);
            wait(0.9);
            }
            else {
                pc.printf("No Lock\r\n");
                wait(1);
                }
                }
                }  
