#include <stdio.h>

#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"

DigitalOut led1(LED1);

void loopForever()
{
    printf("Halt\r\n");

    while (true) {
        printf(".");
        led1 = !led1;
        Thread::wait(1000);
    }
}

int main()
{
    led1 = false;
    int result = 0;
    
    printf("\r\nBegin NTP test\r\n");
    
    result = EthernetInterface::init();
    
    if (result != 0)
    {
        printf("Init failed - %d\r\n", result);
        loopForever();
    }
    
    result = EthernetInterface::connect();
    
    if (result != 0)
    {
        printf("Connect failed - %d\r\n", result);
        loopForever();
    }
    
    time_t ctTime;
    ctTime = time(NULL);  
  
    printf("Current time is (UTC): %s\r\n", ctime(&ctTime));      
    
    NTPClient ntp;
    
    result = ntp.setTime("0.pool.ntp.org");
    
    if (result != 0)
    {
        printf("Settime failed - %d\r\n", result);
        loopForever();
    }
    
    ctTime = time(NULL);  
    printf("\r\nTime is now (UTC): %s\r\n", ctime(&ctTime)); 
    loopForever();
}