/*
 *Marko Spremic 2020/0066
 *Igrica domaci iz pima
 * Pravila igre:
 *Pomocu potenciometara se krece tackica po ekranu. Cilj je da tackica skuplja "vockice" ( vece tackice po enranu).
 *Pritiskom na taster sw1 igra se zavrsava i prikazuje se rezultat na led displeju. Da bi se ponovo pokrenula igrica potrebno je opet kliknuti taster sw1.
 *Pritiskom na taster sw2 generise se nova vockica na ekranu.
**/
#include "mbed.h"
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"


 //I2C bus:
#define SCL PB_13
#define SDA PB_14

//I2C address:
#define I2C_ADDRESS 0x3c
#define I2C_ADD_MBED I2C_ADDRESS<<1
#define I2C_freq 400000

//oled dimensions:
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128
 
//definisanje glavnih promenljivih
BusOut led_dis(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3, PA_2);
DigitalOut SEL2(PC_7);
DigitalOut SEL1(PB_6);
InterruptIn sw1(PC_9);
InterruptIn sw2(PC_8);
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
I2C i2c_obj(SDA, SCL);
Adafruit_SSD1306_I2c myOLED(i2c_obj, PB_5, I2C_ADD_MBED, OLED_HEIGHT_PX, OLED_WIDTH_PX);
//funkcija za generisanje random broja
int random(int lower, int upper)
{

    return (rand() % (upper - lower + 1)) + lower;
}
//definisanje funkcija
void error(); 
void write_num(int broj);
void end_game();
int x, y, x_obj, y_obj; char endgame = 0;

//glavna funkcija
int main()
{
    sw2.fall(&error);
    sw1.fall(&end_game);
    myOLED.begin();
    i2c_obj.frequency(I2C_freq);
    myOLED.clearDisplay();
    myOLED.display();
    unsigned char count = 0;
    srand(time(0));
    x = 0, y = 0, x_obj = random(0, 127) , y_obj = random(0, 63); char check = 0, d1 = 0, d2 = 0;
    while(1)
    {
        //dok traje igra
        if(!endgame)
        {
            SEL2.write(1);
            SEL1.write(1);
            x = pot1 * 128; y = pot2 * 64;
            myOLED.clearDisplay();
            myOLED.fillRect(x, y, 2, 2, WHITE);
            myOLED.fillRect(x_obj, y_obj, 4, 4, WHITE);
            for(int i = 0; i < 4; i++)
                for(int j = 0; j < 4; j++)
                    if( x == x_obj+i && y == y_obj+j)
                    {
                        check = 1;
                        break;
                    }
            myOLED.display();
            if(check)
            {
                x_obj = random(0, 127) , y_obj = random(0, 63);
                myOLED.display();
                count++;
                d1 = count/10; d2 = count%10;
                d1 = (d1 == 0)? -1: d1;
                check = 0;
            }
        }
        //prikazivanje prednosti u toku pauze izmedju dve igre
        else
        {
            SEL2.write(1);
            SEL1.write(0);
            write_num(d1);
            wait_ms(8);
        
            SEL2.write(0);
            SEL1.write(1);
            write_num(d2);
            wait_ms(8);
            count = 0;
        }
    }
    
}
//generisanje nove vockice
void error()
{
    x_obj = random(0, 127) , y_obj = random(0, 63);
}
//ispisivanje vrednosti na led displeju
void write_num(int broj)
{
    switch(broj)
    {
        case 0: led_dis = 0xC0; break;
        case 1: led_dis = 0xF9; break;
        case 2: led_dis = 0xA4; break;
        case 3: led_dis = 0xB0; break;
        case 4: led_dis = 0x99; break;
        case 5: led_dis = 0x92; break;
        case 6: led_dis = 0x82; break;
        case 7: led_dis = 0xF8; break;
        case 8: led_dis = 0x80; break;
        case 9: led_dis = 0x90; break;
        default: led_dis = 0xFF;
    }
}
//zavrsavanje igrice
void end_game()
{
    endgame++;
    endgame = (endgame > 1) ? 0 : endgame;
}