/*
 *Marko Spremic 
 *Indeks: 2020/0066
 */

//ukljucivanje biblioteka
#include "mbed.h"
#include "mb_pins.h"
#include "platform/mbed_thread.h"
#include "MQTTClientMbedOs.h"
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h" 

 
// LED2 blinking rate:
#define BLINKING_RATE_MS                                                     250
// Scaler to 3v3L
#define VOLTAGE_SCALER                                                      3.3f
// Client yield timeout in miliseconds:
#define YIELD_TIMEOUT_MS                                                    1000
// Maximum number of networks to scan for:
#define MAX_NETWORKS                                                          15
// Small delay for network information printing:
#define PRINTF_DELAY_MS                                                       10

 //I2C bus:
#define SCL PB_13
#define SDA PB_14

//I2C address:
#define I2C_ADDRESS 0x3c
#define I2C_ADD_MBED I2C_ADDRESS<<1
#define I2C_freq 400000

//oled dimensions:
#define OLED_HEIGHT_PX 64
#define OLED_WIDTH_PX 128
 
 
 
// Left potentiometer:
AnalogIn pot1(MB_POT1);
// Left button on the motherboard:
InterruptIn sw1(MB_SW1);
// Right LED on the motherboard:
DigitalOut led2(MB_LED2);
// Pointer to a WiFi network object:
WiFiInterface *wifi;
// Creating TCP socket:
TCPSocket socket;
// Creating MQTT client using the TCP socket;
MQTTClient client(&socket);
// Message handler:
MQTT::Message message;
I2C i2c_obj(SDA, SCL);
Adafruit_SSD1306_I2c myOLED(i2c_obj, PB_5, I2C_ADD_MBED, OLED_HEIGHT_PX, OLED_WIDTH_PX);


 
char* topic = "pubpim";
char* topic_sub = "subpim";
// Counter of arrived messages:
int arrivedcount = 0;
// Flag indicating that button is not pressed:
int button_pressed=0;
// HiveMQ broker connectivity information:
const char* hostname = "broker.hivemq.com";
int port = 1883;
char ms_show[100] = "";
// Returning a string for a provided network encryption: 

 
int scan_networks(WiFiInterface *wifi)
{
    printf("Scan\n");
    
    // Scan only for the number of networks, first parameter is NULL:
    int count = wifi->scan(NULL, 0);
    // If there are no networks, count == 0, if there is an error, counter < 0:
    if (count <= 0)
    {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
 
    // Limit number of network arbitrary to some reasonable number:
    count = count < MAX_NETWORKS ? count : MAX_NETWORKS;
    
    // Create a local pointer to an object, which is an array of WiFi APs:
    WiFiAccessPoint *ap = new WiFiAccessPoint[count];
    // Now scan again for 'count' networks and populate the array of APs:
    count = wifi->scan(ap, count);
    
    // This time, the number of entries to 'ap' is returned:
    if (count <= 0) 
    {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    

    delete[] ap;
    return count;
}
//proverava tekst koji je primio
char text_check ( char* text1, char* text2)
{
    int i;
    for(i= 0; 1;i++)
    {   
        if(text1[i] != text2[i])
            return 0;
        if(text1[i] == '\0')
            break;
    }
    return 1;
}


char send_voltage = 0, oled = 0;
 //kada stigne poruka
void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;

    char ms[100]; sprintf(ms, "%.*s",message.payloadlen, (char*)message.payload);
    sprintf(ms_show, "%s", ms);
    send_voltage = text_check(ms, "start")||send_voltage;//ukoliko je poruka start ili je pre toga start bio na 1
    if(text_check(ms, "stop")) send_voltage = 0;//ako je poruka stop start ide na 0
    oled = text_check(ms, "oled")||oled;//ako je poruka oled oled ide na 1 ili ako je oled vec na kecu
    ++arrivedcount;
}
 //pritiskom na dugme prstaje prikaz na oledu
void buttonFunction() {
    
    oled = 0;
   
}


 
int main()
{
    // Set the interrupt event:
    sw1.fall(&buttonFunction); 

    // Create a default network interface:
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }
    
    // Scan for available networks and aquire information about Access Points:
    int count = scan_networks(wifi);
    if (count == 0) {
        printf("No WIFI APs found - can't continue further.\n");
        return -1;
    }
    char send_ms[100] = "";
    
    // Connect to the network with the parameters specified in 'mbed_app.json':
    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }
    
    // Print out the information aquired:
    printf("Success\n\n");

    // Open TCP socket using WiFi network interface:
    socket.open(wifi);
    // Connect to the HiveMQ broker:
    socket.connect(hostname, port);
    // Fill connect data with default values:
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    // Change only ID and protocol version:
    data.MQTTVersion = 3;
    data.clientID.cstring = "pim-21";
    
    // Connect the 
    int rc = 0;
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);
 
    if ((rc = client.subscribe(topic_sub, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);
      
    myOLED.begin();
    i2c_obj.frequency(I2C_freq);
    myOLED.clearDisplay();
    myOLED.display();
    while (true) {
        
        led2 = !led2;
        thread_sleep_for(BLINKING_RATE_MS);
        //ukoliko je primio start
        if (send_voltage) {     
            // QoS 0
            char buf[100];
            
            sprintf(buf, "V(POT1) = %1.2f\r\n", pot1*VOLTAGE_SCALER);
            sprintf(send_ms, "%s", buf);
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            client.publish(topic, message);
            wait(10);
        }
        //ako je primio oled
        if(oled)
        {
            myOLED.clearDisplay();
            myOLED.resetCoordinate();
            myOLED.printf("poslata poruka:\n%s", send_ms);//prikazivanje poslednje poslate poruke
            myOLED.printf("Primljena poruka:\n%s", ms_show);//prikazivanje poslednje primljene poruke
            myOLED.display();
        }
        //ako je stisnuto dugme
        else
        {
            myOLED.clearDisplay();
            myOLED.display();
        }
        

        client.yield(YIELD_TIMEOUT_MS);
    }
}