/*
 *Marko Spremic 
 *Indeks: 2020/0066
 *
 *To ne mora uvek da bude slucaj. Meni za 0 najjace svira zujalica, a za 99 najslabije dotovo da ne. 
 *Kada stavimo duty cycle na 10%, piezo ce biti distortovan 10% vremena, a 90% neaktivan. Oslcilaciona proporcija je niska.
 *Kada stavimo duty cycle na 50%, piezo ce biti distortovan pola vremena, a pola neaktivan. Oslcilaciona proporcija je visoka. Piezo osciluje na velikoj amplitudi, pola vremena, a pola vremena neaktivan.
 *Kada stavimo duty cycle na 90%, piezo ce biti distortovan 90% vremena, a 10% neaktivan. Oslcilaciona proporcija je niska, zato sto je razlika izmedju distorzije i neaktivnosti velika.
 *Iz toga najglasnija bi trebala da bude na 50%, pa da opada ka 100%, odnosno ka 0%.
 *Mada ovo sam uocio da zavisi i od frekvencije na kojoj se zvuk pusta. Ovo sam ja zakljucio nakon malo isprobavanja sa plocom, dok sam ovo iznad nasao na netu.
 */
//Ukljucivanje biblioteka:
#include "mbed.h"
 
//Definisanje direktiva:
#define time 8
 
  
//Definisanje glavnih promenljivih:
AnalogIn pot1(PA_0);
AnalogIn pot2(PA_1);
PwmOut buzz(PA_11);
InterruptIn sw1(PC_13);
InterruptIn sw2(PC_8);
BusOut led_dis(PA_10, PA_9, PA_8, PB_10, PB_5, PB_4, PB_3, PA_2);
DigitalOut SEL2(PC_7);
DigitalOut SEL1(PB_6);

//Globalne promenljive:
char check = 0, check1 = 0;   

//Definisanje pomocne funkcije:
void ISR_sw2(void);
void write_num(int broj);

 //Definisanje glavne funkcije:
int main()
{
    sw2.fall(&ISR_sw2);
    double pot1_vr = 0, pot2_vr = 0, period_buzz = 0; char x1 = -1, x2 = 0; int vr = 0;
    buzz.write(0);
    while(1)
    {
        //glavna petlja
        pot1_vr = pot1.read();
        pot2_vr = pot2.read();
        vr = (int)(pot1_vr*100);
        period_buzz = 50+4950*pot2_vr;
        buzz.write(pot1_vr);
        buzz.period_us(period_buzz);
        if(check&&check1)
        {
            //brojevi za prikazivanje
            x1 = (char)vr/10;
            x2 = (char)vr%10;    
            if(x1 == 0) x1 = -1;        
            check1 = 0;
        }
        /*else
        {
            x1 = -1;
            x2 = -1;
        }*/
        SEL2.write(1);
        SEL1.write(0);
        write_num(x1);
        wait_ms(time);
        
        SEL2.write(0);
        SEL1.write(1);
        write_num(x2);
        wait_ms(time); 
    }
}
//azuriranje displeja
void ISR_sw2()
{
    check = (check)? 0 : 1;
    check1 = 1;
}
//Ispisivanje broja na displeju
 void write_num(int broj)
 {
     switch(broj)
     {
         case 0: led_dis = 0xC0; break;
         case 1: led_dis = 0xF9; break;
         case 2: led_dis = 0xA4; break;
         case 3: led_dis = 0xB0; break;
         case 4: led_dis = 0x99; break;
         case 5: led_dis = 0x92; break;
         case 6: led_dis = 0x82; break;
         case 7: led_dis = 0xF8; break;
         case 8: led_dis = 0x80; break;
         case 9: led_dis = 0x90; break;
         default: led_dis = 0xFF;
     }
 }