#include "mbed.h"
 
#define THERMISTORNOMINAL 10000      
#define TEMPERATURENOMINAL 25
#define BCOEFFICIENT 3435
//#define SERIESRESISTOR 10000
#define SERIESRESISTOR 10000
#define TEMPRATE 0.2
#define NUMSAMPLES 100

AnalogIn thermistor1(A0);
AnalogIn thermistor2(A1);
AnalogIn thermistor3(A2);
AnalogIn thermistor4(A3);
AnalogIn thermistor5(A4);
AnalogIn thermistor6(A5);
AnalogIn thermistor7(D11);
 Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut led(LED1);
float tempArray[7];
unsigned int samples[NUMSAMPLES];

void readProbeX(int probeNum) {
    float resistance = 0;
    float average;
    int i;
    for (i=0; i< NUMSAMPLES; i++) {
        switch (probeNum){
            case 0:
            samples[i] = thermistor1.read_u16();
            break;
            case 1:
            samples[i] = thermistor2.read_u16();
            break;
             case 2:
            samples[i] = thermistor3.read_u16();
            break;
             case 3:
            samples[i] = thermistor4.read_u16();
            break;
             case 4:
            samples[i] = thermistor5.read_u16();
            break;
             case 5:
            samples[i] = thermistor6.read_u16();
            break;
            case 6:
            resistance = thermistor7.read_u16();
            break;
            default:
            break;
                
        }
        wait(0.002);
    }
    // average all the samples out
    average = 0;
    for (i=0; i< NUMSAMPLES; i++) {
        average += samples[i];
    }
    average /= NUMSAMPLES;
    resistance = average;
    resistance = (float) SERIESRESISTOR / ((65536 / resistance) - 1.0);
    float steinhart;
    steinhart = (log(resistance / THERMISTORNOMINAL))/BCOEFFICIENT + (1.0 / (TEMPERATURENOMINAL + 273.15));
    steinhart = (1.0 / steinhart) - 273.15;   
    tempArray[probeNum] = steinhart;    
    //printf("read temp %d = %.1f C\n",probeNum,  tempArray[probeNum]);
    //wait(0.5);
}
void init(){

}
int main() {
    //printf("\nFermenter Temp Array\n");
     //pc.printf("Hello World !\n");
    while(1) {
        int x;
        for (x = 0;  x < 7; x++){
            readProbeX(x);
        }
        for (x = 6;  x >= 0; x--){
            printf("Temp Probe %d = %.1f C\n",x,  tempArray[x]);
        }
        //printf("%.1f,%.1f,%.1f,%.1f,%.1f,%.1f,%.1f\n", tempArray[0], tempArray[1], tempArray[2], tempArray[3], tempArray[4], tempArray[5], tempArray[6]);
        pc.printf("\n");
        wait(5.0);
 
    }

}

