#include "mbed.h"
#include "TextLCD.h"
#include "data.h"
// Green wire to pin13
// White wire to pin14

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX);
Serial gps(p13, p14);
TextLCD lcd(p21, p22, p23, p24, p25, p27, p28);


int parseGSV() {
                    gsv2 = strtok(gsv1, ",");
                    while (gsv2 != NULL) {
                        sep++;
                        switch (sep) {
                            case 1:
                                // # of sentences
                                lcd.printf("#:%s\n",gsv2);
                            break;
                            case 2 :
                                // Sentence # of #
                                lcd.printf("S#:%s",gsv2);
                            break;
                            case 3 :
                                // Number of Satellites in view (Should give a hint as to how many cases to expect here...
                                lcd.printf("#:%s\n",gsv2);
                            break;
                            case 4 :
                                // Satellite PRN Number
                                lcd.printf("PRN#:%s\n",gsv2);
                            break;
                            case 5 :
                                // Elevation in Degrees
                            break;
                            case 6:
                                // Azimuth in Degrees 
                            break;
                            case 7:
                                // SNR - up to 4 satellites per sentence
                            break;
                        }
                        gsv2 = strtok(NULL, ",");
                    }
                    sep = 0;
    return *gsv2;
}

int parseRMC() {

    return 0;
}

int parseGGA() {
                    gga2 = strtok(gga1, ",");
                    while (gga2 != NULL) {
                        sep++;
                        switch (sep) {
                            case 1:
                                if (mode == 1) {
                                    lcd.cls();
                                    lcd.printf("Time:%s\n",gga2);
                                }
                            break;
                            case 2 :
                                if (mode == 2) {
                                    lcd.cls();
                                    lcd.printf("Lat:%s",gga2);
                                }
                            break;
                            case 3 :
                                if (mode == 2) {
                                    lcd.printf("%s\n",gga2);
                                    wait(0.25);
                                }
                            break;
                            case 4 :
                                if (mode == 2) {
                                    lcd.cls();
                                    lcd.printf("Lon:%s",gga2);
                                }
                            break;
                            case 5 :
                                if (mode == 2) {
                                    lcd.printf("%s\n",gga2);
                                    wait(0.25);
                                }
                            break;
                            case 6:
                                if (mode == 1) {
                                    if (gga2 == "0") {
                                        fix = "Invalid";
                                    }
                                    if (gga2 == "1") {
                                        fix = "GPS Fix (SPS)";
                                    }
                                    if (gga2 == "2") {
                                        fix = "DGPS Fix";
                                    }
                                    if (gga2 == "3") {
                                        fix = "PPS Fix";
                                    }
                                    if (gga2 == "4") {
                                        fix = "Real Time Kinematic";
                                    }
                                    if (gga2 == "5") {
                                        fix = "Float RTK";
                                    }
                                    if (gga2 == "6") {
                                        fix = "Estimated (Dead Reckoning)";
                                    }
                                    if (gga2 == "7") {
                                        fix = "Manual Input Mode";
                                    }
                                    if (gga2 == "8") {
                                        fix = "Simulation Mode";
                                    }
                                    lcd.printf("FIX: %s_%s",gga2,fix);
                                }
                            break;
                        }
                        gga2 = strtok(NULL, ",");
                    }
                    sep = 0;
    return *gga2;
}

int getGPSstring(int str) {
    if (gps.scanf("%s", &gpsString) ==1) {
        if (str == 1) {
            if (sscanf(gpsString, "$GPGSV,%s",gsv1) >= 1) {
                sep = 0;
                parseGSV();
            }
        return *gsv2;
        }
        if (str == 2) {
            if (sscanf(gpsString, "$GPRMC,%s",rmc1) >= 1) {
                sep = 0;
                parseRMC();
            }
        return *rmc2;
        }
        if (str == 3) {
            if (sscanf(gpsString, "$GPGGA,%s",gga1) >=1) {
                sep = 0;
                parseGGA();
            }
        return *gga2;
        }
    }
    return 0;
}
