#include "mbed.h"

/*
MJB
10th August 2010


To power a LED 7x5 dot matrix.

This project uses the display from RS Components: 247-3141.

The connections are as follows:
    Pin 16 = column 1 Display pin 1 (left-most column)
    Pin 17 = column 2 Display pin 3
    Pin 18 = column 3 Display pin 10
    Pin 19 = column 4 Display pin 7
    Pin 20 = column 5 Display pin 8 (right-most column)

    Pin 21 = row 1 Display pin 12 (top-most row)
    Pin 22 = row 2 Display pin 11
    Pin 23 = row 3 Display pin 2
    Pin 24 = row 4 Display pin 9
    Pin 25 = row 5 Display pin 4
    Pin 26 = row 6 Display pin 5
    Pin 27 = row 7 Display pin 6

    The code causes the message to scroll across the display.
*/

BusOut Rows (p21, p22, p23, p24, p25, p26, p27);
BusOut Cols (p16, p17, p18, p19, p20);
BusOut IntLEDs(LED1, LED2, LED3, LED4);


int DotPattern1[] = {0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
                     0x7F, 0x00, 0x7F, 0x7E, 0x7E,
                     0x00, 0x7E, 0x7E, 0x7F, 0x78,
                     0x47, 0x3F, 0x47, 0x3F, 0x47,
                     0x78, 0x7F, 0x7F, 0x7F, 0x7F,
                     0x5D, 0x3A, 0x36, 0x4D, 0x7F,
                     0x43, 0x3F, 0x5F, 0x3F, 0x43,
                     0x7F, 0x02, 0x7F, 0x7D, 0x40,
                     0x3D, 0x5D, 0x7F, 0x47, 0x3B,
                     0x3B, 0x57, 0x7F, 0x00, 0x7B,
                     0x03, 0x7F, 0x47, 0x2B, 0x2B,
                     0x37, 0x7F, 0x37, 0x2B, 0x5B,
                     0x7F, 0x7F, 0x7F, 0x7F, 0x7F,
                     0x7f, 0x7f, 0x7f, 0x7f, 0x7f
                    };  //Message = "ITW Switches".

float count;
int ColCount;
int pattern;
int loop;
int index;

int main() {

    while (1) {

        index=0;
        while (index<65) {
            loop=0;
            while (loop<4) {
            IntLEDs = index;
                count = 1;
                pattern = 0+index;
                while (count<0x20) {
                    Cols = count;
                    Rows = DotPattern1[pattern];
                    wait_ms(5);
                    count = count*2;
                    pattern++;
                }
                loop++;
            }

            index++;
        }
    }
}





