#include "mbed.h"

#if defined (TARGET_MBED_LPC1768)
// Defines for sensors I2C
#define SDA     p9
#define SCL     p10

#elif defined (TARGET_SSCI824)
// Defines for sensors I2C
#define SDA     dp4
#define SCL     dp5

#elif defined (TARGET_LPC11U35_401)
// Defines for sensors I2C
#define SDA     P0_5
#define SCL     P0_4

#else
#error "Unknown target type"
#endif

#define I2C_ADDRES (0x1c<<1)
Serial pc(USBTX, USBRX);
I2C i2c(SDA, SCL);
char temp[6];

int main()
{
    pc.baud(115200);

    wait(1.0);

    memset(temp, 0, sizeof(temp));
    temp[0]=0x0D; // REG_WHO_AM_I
    if(i2c.write(I2C_ADDRES, temp, 1, true) != 0) pc.printf("I2C write error\r\n");
    memset(temp, 0, sizeof(temp));
    if(i2c.read(I2C_ADDRES, temp, 1, false) != 0) pc.printf("I2C read error\r\n");
    pc.printf("ID is %X\r\n",(int)temp[0]); // ID is 0x1A

    memset(temp, 0, sizeof(temp));
    temp[0]=0x2A; // REG_CTRL_REG1
    temp[1]=0x19; // Data
    if(i2c.write(I2C_ADDRES, temp, 2, false) != 0) pc.printf("I2C write error\r\n");

    while(1) {}
}
