/*************************************************************

 main.c

*************************************************************/
#include "geiger.h"

void calculate_sv(){
    cpm = 0;
    for(int i=0; i<=first_touch_index; i++){
        cpm += cpm_array[i];
    }
    cpm /= ((first_touch_index+1)*((float)CHUNK/60));
    
    uSv = cpm/carib + offset_usv;
    if (uSv <0) uSv = 0;
  
    //peak usv set
    if(peak_uSv<uSv){
        peak_uSv=uSv;
    }

    // for long term average
    long_cpm=0;
    unsigned long cpm_sum=0;
    for (int i=0; i<= long_first_touch_index; i++) {
        cpm_sum += long_cpm_array[i];
    }
    cpm_sum *= 60;
    long_cpm = (float)cpm_sum / ((long_first_touch_index)*60+count_second);
    long_uSv = long_cpm/carib + offset_usv;
    
#ifdef DEBUG
    pc.printf("cpm=%3d,usv=%.3f,longcpm=%ld,long_usv=%.3f\r\n",(int)cpm,uSv,(long)long_cpm,long_uSv);
#endif

}

void next_geiger_countup(){
 
    cnt = 0;
    if(++cpm_index>=cpm_array_max){
        cpm_index=0;
    }  
    //first touch index count up
    if(cpm_index>first_touch_index){
        first_touch_index=cpm_index;
    }
    cpm_array[cpm_index]=cnt;

    // for long term average
    if (++count_second >= 60) {
        if (++long_cpm_index >= long_cpm_array_max+1) {
            long_cpm_index = 0;
        }
        long_cpm_array[long_cpm_index] = 0;
        count_second = 0;

        if(long_cpm_index > long_first_touch_index){
            long_first_touch_index = long_cpm_index;
        }
    }

}


// Timer -- called every 1 min.
Ticker timer;

void attime(){

    next_geiger_countup();
    if(++updateintervalcount > updateinterval){
        updateflag=1;
        updateintervalcount=0;
    }
}


void geiger()
{
    if(mode==1){
        read_dma_data();
    }

    cnt++;
    cpm_array[cpm_index]=cnt;
    long_cpm_array[long_cpm_index]++;
    
    *outLED=1;
    if(sound==1) *buzzer=1;
    click.attach(&buzzer_off,0.03);
}

void whereami() {
     if(gps->sample()&& gps->longitude!=0 && gps->latitude!=0) {
         printf("GPS:%f/%f,", gps->longitude, gps->latitude);
     }
}


void console_output(){
    char msg[256];
    msg[0]='\0';
    if(++console_output_flag>2){
      printable_msg(msg);
      printf("%s",msg);
      console_output_flag=0;
    }
}

//NTP setup
void ntpget() {

    Host server(IpAddr(), 123, "jp.pool.ntp.org");
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Get NTP.");
    ntpRet = ntp.setTime(server);

}

void pulldown() {
    DigitalIn dp05(p5);     dp05.mode(PullDown);
    DigitalIn dp06(p6);     dp06.mode(PullDown);
    DigitalIn dp07(p7);     dp07.mode(PullDown);
    DigitalIn dp08(p8);     dp08.mode(PullDown);
    DigitalIn dp09(p9);     dp09.mode(PullDown);
    DigitalIn dp10(p10);    dp10.mode(PullDown);
    DigitalIn dp11(p11);    dp11.mode(PullDown);
    DigitalIn dp12(p12);    dp12.mode(PullDown);
    DigitalIn dp13(p13);    dp13.mode(PullDown);
    DigitalIn dp14(p14);    dp14.mode(PullDown);
    DigitalIn dp15(p15);    dp15.mode(PullDown);
    DigitalIn dp16(p16);    dp16.mode(PullDown);
    DigitalIn dp17(p17);    dp17.mode(PullDown);
    //DigitalIn dp18(p18);    dp18.mode(PullDown);
    DigitalIn dp19(p19);    dp19.mode(PullDown);
    DigitalIn dp20(p20);    dp20.mode(PullDown);
    DigitalIn dp21(p21);    dp21.mode(PullDown);
    //DigitalIn dp22(p22);    dp22.mode(PullDown);
    //DigitalIn dp23(p23);    dp23.mode(PullDown);
    //DigitalIn dp24(p24);    dp24.mode(PullDown);
    DigitalIn dp25(p25);    dp25.mode(PullDown);
    //DigitalIn dp26(p26);    dp26.mode(PullDown);
    //DigitalIn dp27(p27);    dp27.mode(PullDown);
    //DigitalIn dp28(p28);    dp28.mode(PullDown);
    //DigitalIn dp29(p29);    dp29.mode(PullDown);
    //DigitalIn dp30(p30);    dp30.mode(PullDown);
}

/****************  main  ***************************/

int main() {
    pulldown();

    AnalogOut tri(p18);
    tri = 0.0;

    //cpu_setting();

    // See http://mbed.org/users/no2chem/notebook/mbed-clock-control--benchmarks/
    setSystemFrequency(0x3, 0x1, cpu_speed, 1); // Set clock freq 96MHz (full speed) 
    SystemCoreClockUpdate();
    pc.baud(460800);

    EthernetErr ethErr;

    environment_setting(fwserver);

    // malloc for long average  
    long_cpm_array = (unsigned int *)malloc((long_cpm_array_max+1) * sizeof(unsigned int) );
    if (long_cpm_array == NULL) {
        lcd.cls();
        lcd.printf("Can't malloc for long_cpm_array");
        pc.printf("Can't malloc for long_cpm_array");
        abort();
    }
    
    if (mode != -1) {
        switch(updatetype){
        case 0:
            break;
        case 1:
            twitter_setup();
            break;
        case 2:
            pachube_setup(&appconf);
            break;
        default:
            lcd.cls();lcd.locate(0,0);
            lcd.printf("No update to the internet\n");
            break;
        }
        wait(0.5);
    }
    
  // ******  Initializing objects ********
    PachubeV2CSV web(appconf.apikey);
    
    if (mode==1) {
        AnalogIn Sense15_(pin_assign(AnalogInput_pin_number));
        Sense15=&Sense15_;
    }

    InterruptIn Geiger_signal(pin_assign(GMInterrupt_pin_number)); // Geiger signal

    DigitalOut buzzer_(pin_assign(Buzzer_pin_number));
    buzzer=&buzzer_;

    DigitalOut outLED_(pin_assign(LED_pin_number));
    outLED=&outLED_;

    GPS gps_(pin_assign(GPStx_pin_number), pin_assign(GPSrx_pin_number));
    gps=&gps_;
   
    if (mode != -1) {
        printf("Version: %s\n",VERSION);
        lcd.cls();
        lcd.printf("Ver %s\n",VERSION);
        wait(2);
        
        char msg[256] = "";
        fullcalendarHyoji(msg);
        printf("Self Clock: %s\n",msg);
        
        // Ethernet setup
        fwup = new FirmwareUpdater(fwserver, BINNAME, &commonClient,true);
    
        if (eth0.link()) {
            lcd.locate(0,0);lcd.cls();lcd.printf("Setting up the Internet(DHCP)\n");
            ethErr = eth.setup();
            lcd.cls(); lcd.locate(0,0);
            if(ethErr){
                lcd.printf("Please plug into the Internet.");
                printf("Error %d in setup.\n", ethErr);
            }else{
                noInternet=0;
                IpAddr ipadr = eth.getIp();
                lcd.printf("IP=%d.%d.%d.%d\n",
                    ipadr[0],ipadr[1],ipadr[2],ipadr[3]);
                wait(2);
                if(firmware_update_interval > 0) {
                    check_newfirm();
                }
                ntpget();
    
                memset((char *)msg, '\0', 256);
                fullcalendarHyoji(msg);
                printf("NTP Clock:  %s\n",msg);
            }
        }
    } // end if (mode != -1)

    if (mode == 1) {
        setup_adcdma(); 
    }

    // Geiger setup
    float stepvolt;
    const int step=40;
    for (stepvolt=0; stepvolt<volt; ) {
        lcd.cls();
        lcd.printf("volt=%.0f\n", stepvolt);
        tri = stepvolt/voltagedivider/3.3;
        wait(0.5);
        stepvolt+=step;
    }
    lcd.cls();
    lcd.printf("volt=%.0f\n", volt);
    tri = volt/voltagedivider/3.3;
    wait(0.5);
    
    for(int i=10; i>0; i--) {
        lcd.cls();
        lcd.printf("Wait %2dsec for stabilize voltage",i);
        wait(1);
    }

    Geiger_signal.rise(&geiger);
    Geiger_signal.mode(PullDown);

    // timer interrupt
    timer.attach(&attime, CHUNK);

    int firmware_update_term = firmware_update_interval * 60 / (updateinterval/60);
    int firmware_update_counter=0;
    
    if (mode != -1) {
        for(int i=init_stabilize_time; i>0; i--) {
            lcd.cls();
            lcd.printf("Wait %2dsec for stabilize cpm",i);
            wait(1);
        }
    }

    //************* Main Loop ******************//
    while(1){

        if (mode == -1) {
            LCD_cpm_output();
        } else if (mode != 3) {
            LCD_time_and_output();
        }
//      console_output();

        wait(1.0);
        if(mode==2){
            whereami();
        }
        if(mode != -1 && updateflag){
            updateflag=0;
            if (noInternet==1 && eth0.link()==1){
                ethErr = eth.setup();
                if(ethErr) {
                } else {
                    noInternet=0;
                    ntpget();
                }
            }

            if (!noInternet) {
                switch(updatetype){
                case 0:
                    break;
                case 1:          
                    twitter_output();
                    break;
                case 2:
                    printf("pachube\r\n");
                    pachube_output(&web, &commonClient);
                    printf("data uploaded to pachube\n");
                    break;
                default:
                    break;
                }
        
                if(firmware_update_interval > 0 &&
                   firmware_update_counter++ >= firmware_update_term){
                    if(fwup->exist()==0) {
                        mbed_reset();
                    } else {
                        firmware_update_counter = 0;
                    }
                    ntpget();
                }          
            }// !noInternet
        }//if update flag
    }//while
}//main


