/*************************************************************

 config_env.c  

*************************************************************/
#include "mbed.h"
#include "TextLCD.h"
#define CHUNK   1
#define AVERAGE_MIN 10*60/CHUNK
#define TMP_TEXT_BUF_SIZE (256)

static char envini[] = "/local/env.ini";
#define default_fwserver  "http://diytec.web.fc2.com/mark2r2/firmware"
//char default_fwserver[] = "http://diytec.web.fc2.com/mark2r2/firmware";

extern int mode,gps_mode;
extern int shape_mode;
extern int AnalogInput_pin_number;
extern int GMInterrupt_pin_number;
extern int LED_pin_number;
extern int Buzzer_pin_number;
extern int GPStx_pin_number;
extern int GPSrx_pin_number;
extern float carib;
extern int updateinterval;
extern int updatetype;  /* 0: no 1: twitter 2: pachube */
extern int sound;    /* 0: off  1: on */
extern float volt; /* voltage executed to GM tube */
extern float offset_usv;
extern TextLCD lcd;
extern int firmware_update_interval;
extern time_t tz_offset;
extern Serial pc;
extern int init_stabilize_time;
extern int cpu_speed;

extern float carib_cpm0;
extern float carib_usv0;
extern float carib_cpm1;
extern float carib_usv1;
extern unsigned int cpm_array_max;
extern unsigned int long_cpm_array_max;

void trim(char *retbuff, char *inbuff) {
    int i,j,len;
    
    len=strlen(inbuff);
    for(i=0,j=0;i<len; i++){
        if(inbuff[i]>0x20) {
            retbuff[j]=inbuff[i];
            j++;
        }
    }
    retbuff[j]='\0';


}


int GetStatus(char *path, char *tag, char *text){
    char TmpText[TMP_TEXT_BUF_SIZE];
    char TmpTag[TMP_TEXT_BUF_SIZE];
    FILE *stm = fopen(path, "r");
    
    if(stm != NULL){
        text[0] = '\0';
        sprintf(TmpTag, "%s:%%s",tag);
        
        while(fgets(TmpText, TMP_TEXT_BUF_SIZE, stm) != NULL){
            if(sscanf(TmpText, TmpTag, text)==EOF){
                printf("error reading %s",tag);
            }
        }
        fclose(stm);
    }    
    else {
        printf("file open error: %s\r\n",path);
        lcd.cls();
        lcd.printf("open err: %s",path);
        abort();
    }    

    return(0);
}

/*-----------
//  
    // See http://mbed.org/users/no2chem/notebook/mbed-clock-control--benchmarks/

// NOTE:if the clock speed is down, the power consumption becomes low but the timer becomes slow.

void cpu_setting() {                                //  2011/08/19
    char msgs[80];

    if(GetStatus(envfile,"cpu_speed",msgs)==0){      
        int m = atoi(msgs);
        if(m >= 6 && m <= 12){
            cpu_speed=atof(msgs);
        }
     }
}
--------------*/

#define IntVal       1   //int (positive only)
#define IntVal_t1    2   //int (-1 is permitted)
#define TimeVal      3   //time_t
#define UintVal      4   //unsigned int
#define FloatVal     5   //float
#define FloatVal_t1  6   //float (negative permitted)
#define FloatVal_t2  7   //float (negative & 0 permitted)

static char gmfile[20];

// For env.ini
struct envGet {
    char*   str;
    int     envtype;
    void*   datval;
    char*   file_id;
} EnvGetTable[] = {
    {"mode", IntVal_t1, &mode, envini},
    {"shape", IntVal, &shape_mode, envini},
    {"gps", IntVal, &gps_mode, envini},
    {"updateinterval",IntVal,&updateinterval, envini},
    {"updatetype", IntVal, &updatetype, envini},
    {"sound", IntVal, &sound, envini},
    {"firmware_update_interval",IntVal,&firmware_update_interval, envini},
    {"timezone",TimeVal, &tz_offset, envini},
    {"init_stabilize_time", IntVal, &init_stabilize_time, envini},
    {"GMInterrupt", IntVal, &GMInterrupt_pin_number, envini},
    {"LED", IntVal, &LED_pin_number, envini},
    {"Buzzer", IntVal, &Buzzer_pin_number, envini},
    {"GPStx", IntVal, &GPStx_pin_number, envini},
    {"GPSrx", IntVal, &GPSrx_pin_number, envini},
    {"cpm_array_max", UintVal, &cpm_array_max, envini},
    {"long_cpm_array_max", UintVal, &long_cpm_array_max, envini},
    {"cariburation",FloatVal, &carib, gmfile},
    {"voltage",FloatVal, &volt, gmfile},
    {"offset_usv", FloatVal_t1, &offset_usv, gmfile},
    {"cpm0", FloatVal, &carib_cpm0, gmfile},
    {"usv0", FloatVal, &carib_usv0, gmfile},
    {"cpm1", FloatVal, &carib_cpm1, gmfile},
    {"usv1", FloatVal, &carib_usv1, gmfile},  
    {"uSv0", FloatVal_t2, &carib_usv0, gmfile},
    {"uSv1", FloatVal_t2, &carib_usv1, gmfile}
};

void environment_setting(char *fws){
    char msgs[80];
    char gmtype[50];

    // GM tube characteristic feature reading //    
    if(GetStatus(envini,"gmtype",gmtype)==0){
        strcpy(gmfile,"/local/");
        strcat(gmfile,gmtype);
        printf("%s will be used for GM tube cariburation\n",gmfile);
    
        for(int i=0; i<sizeof(EnvGetTable)/sizeof(envGet) ; i++ ) {
            if(GetStatus(EnvGetTable[i].file_id,EnvGetTable[i].str,msgs)==0){
                switch(EnvGetTable[i].envtype) {
                    case IntVal:
                        if(atoi(msgs)>0){
                            *((int*)EnvGetTable[i].datval)=atoi(msgs);
                        }
                        printf("%s=%d\r\n", EnvGetTable[i].str, *((int*)EnvGetTable[i].datval));
                    break;
                    case IntVal_t1:
                        if(atoi(msgs)>0 || atoi(msgs)==-1){
                            *((int*)EnvGetTable[i].datval)=atoi(msgs);
                        }
                        printf("%s=%d\r\n", EnvGetTable[i].str, *((int*)EnvGetTable[i].datval));
                    break;
                    case TimeVal:
                        if(msgs[0] != '\0'){
                            *((time_t*)EnvGetTable[i].datval)=atoi(msgs);
                        }
                        printf("%s=%d\r\n", EnvGetTable[i].str, *((time_t*)EnvGetTable[i].datval));
                    break;
                    case UintVal:
                        if(atoi(msgs)>0){
                            *((unsigned int*)EnvGetTable[i].datval)=atoi(msgs);
                        }
                        printf("%s=%d\r\n", EnvGetTable[i].str, *((unsigned int*)EnvGetTable[i].datval));
                    break;
                    case FloatVal:
                        if(atof(msgs)>= 0){
                            *((float*)EnvGetTable[i].datval)=atof(msgs);
                        }
                        printf("%s=%f\r\n", EnvGetTable[i].str, *((float*)EnvGetTable[i].datval));
                    break;
                     case FloatVal_t1:
                        *((float*)EnvGetTable[i].datval)=atof(msgs);
                        printf("%s=%f\r\n", EnvGetTable[i].str, *((float*)EnvGetTable[i].datval));
                    break;              
                     case FloatVal_t2:
                        if(atof(msgs)> 0){
                            *((float*)EnvGetTable[i].datval)=atof(msgs);
                            printf("%s=%f\r\n", EnvGetTable[i].str, *((float*)EnvGetTable[i].datval));
                        }                                                                                   
                    break;              
                    
                }
            }
        }
        
        if(GetStatus(envini,"fwserver",msgs)==0){
            if(strlen(msgs) <= 3){
                strcpy(fws, default_fwserver);
            } else {
                trim(fws,msgs);
            }
        }
        printf("fwserver=%s\r\n", fws);
    
        updateinterval*=(60/CHUNK);
        tz_offset *= 3600;
    
        // override by 2 point cariburation
        if (carib_cpm0 > 0 && carib_usv0 > 0 && 
            carib_cpm1 > 0 && carib_usv1 > 0 &&
            (carib_cpm0 < carib_cpm1 && carib_usv0 < carib_usv1) ||
            (carib_cpm0 > carib_cpm1 && carib_usv0 > carib_usv1)) {
            carib = (carib_cpm1 - carib_cpm0) / (carib_usv1 - carib_usv0);
            offset_usv = carib_usv0 - (carib_cpm0 / carib);
            printf("2 point cariburation=%f\r\n", carib);
            printf("2 point offset_usv=%f\r\n", offset_usv);
        }
    
        if( (updatetype == 0) && (cpm_array_max <10)) {
        } else {
            cpm_array_max = 10;
        }
        cpm_array_max *= 60/CHUNK;
    }
}
