/*************************************************************

 pachube.c
 
*************************************************************/
#include "PachubeV2CSV.h"
#include "TextLCD.h"
#include "appconf.h"
#define PACHUBE_CODE_OK 200
#define CONFIG_FILENAME "/local/PACHUBE.CFG"

extern float uSv;
extern float cpm;
extern TextLCD lcd;
extern int mode;
extern appconf_t appconf;
extern float long_cpm;
extern float long_uSv;

void convertDoubleToChar(double val, char *buf, size_t bufsiz) {
    snprintf(buf, bufsiz, "%f", val);
}

void pachube_setup(appconf_t *appconf){
        lcd.cls();
        lcd.locate(0, 0);
        lcd.printf("cfg file Reading...");
        lcd.locate(0, 1);
        lcd.printf("Setup: ");
        appconf_init(appconf);
        if (appconf_read(CONFIG_FILENAME, appconf) != 0) {
            lcd.printf("[NG]");
            error("Failure to read a configuration file.\n");
        }
        else{
            lcd.printf("[OK]");
            wait(1);
        }
        printf("pachube apikey %s\n",appconf->apikey);
}

int web_post(PachubeV2CSV *web, int feed_id, int stream_no, double value, HTTPClient *pClient) {
    char value_text[16];
    convertDoubleToChar(value, value_text, sizeof(value_text));
    char stream_no_text[8];
    stream_no_text[0] = "0123456789"[stream_no];
    stream_no_text[1] = '\0';
    return web->updateDataStream(feed_id, stream_no_text, std::string(value_text), pClient);

}

void pachube_output(PachubeV2CSV* web, HTTPClient *pClient){
    int feed_id = atoi(appconf.feedid);
    
    if (appconf.stream_nsv0 >= 0) {
        if (web_post(web, feed_id, appconf.stream_nsv0,(double)uSv*1000, pClient) != PACHUBE_CODE_OK) {
          lcd.printf("Checking Pachube status:x");
          printf("upload failed -stream1 \n");
          wait(3);
        } else {
          printf("upload -stream1 \r\n");
        }
    }

    if (appconf.stream_cpm0 >= 0) {
        if (web_post(web, feed_id, appconf.stream_cpm0, (double)cpm, pClient) != PACHUBE_CODE_OK){
          lcd.printf("Checking Pachube status:x");
          printf("upload failed -stream2 \n");
          wait(3);
        } else {
          printf("upload -stream2 \r\n");
        }
    }
        
    if (appconf.stream_nsvlong0 >= 0) {
        if (web_post(web, feed_id, appconf.stream_nsvlong0, (double)long_uSv*1000, pClient) != PACHUBE_CODE_OK){  //  2011/08/23
          lcd.printf("Checking Pachube status:x");
          printf("upload failed -stream3 \n");
          wait(3);
        } else {
          printf("upload -stream3 \r\n");
        }
    }
    if (appconf.stream_cpmlong0 >= 0) {
        if (web_post(web, feed_id, appconf.stream_cpmlong0, (double)long_cpm, pClient) != PACHUBE_CODE_OK){  //  2011/08/23
          lcd.printf("Checking Pachube status:x");
          printf("upload failed -stream4 \n");
          wait(3);
        } else {
          printf("upload -stream4 \r\n");
        }
    }
}
