/*************************************************************

 geiger.h
 
*************************************************************/

#define VERSION "1.0"
#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "HTTPClient.h"
#include "ClockControl/ClockControl.h"
#include "PachubeV2CSV.h"
#include "appconf.h"
#include "FirmwareUpdater.h"
#define CONFIG_FILENAME "/local/PACHUBE.CFG"
#include "GPS.h"


#define TMP_TEXT_BUF_SIZE (256)
#define CHUNK   1
#define AVERAGE_MIN 10*60/CHUNK

char BINNAME[] = "geiger";

extern void buzzer_off(DigitalOut*);
extern PinName pin_assign(int);
extern void convertDoubleToChar(double , char *, size_t );
extern void pachube_output(PachubeV2CSV*, HTTPClient *);
extern int web_post(PachubeV2CSV *, int , int , double );
extern void pachube_setup(appconf_t *);
extern int GetStatus(char *, char *, char *);
extern unsigned char GetFileLine(FILE *, char *);
extern void environment_setting(char *);
extern void buzzer_off();
extern void check_newfirm();
extern void TwitMsg(char *);
extern void twitter_output(void);
extern void twitter_setup();
extern void calendarHyoji(char *);
extern void fullcalendarHyoji(char *);
extern void printable_msg(char* );
extern void LCD_time_and_output();
extern void LCD_cpm_output();
extern void read_dma_data();
extern void setup_adcdma();

// for pin assignment and mode setting

int mode=0,gps_mode=0;
int shape_mode=0;
int AnalogInput_pin_number=15;
int GMInterrupt_pin_number=17;
int GMbetaInterrupt_pin_number=16;
int LED_pin_number=23;
int Buzzer_pin_number=22;
int GPStx_pin_number=13;
int GPSrx_pin_number=14;

extern "C" void mbed_reset();
appconf_t appconf;
int noInternet=1;
NTPResult ntpRet=NTP_TIMEOUT;

// display device
Serial pc(USBTX, USBRX);
TextLCD  lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3

// local<-> global conversion
AnalogIn *Sense15;
GPS *gps;
DigitalOut *buzzer;
DigitalOut *outLED;
FirmwareUpdater *fwup;

//for average calculate arrays
unsigned int cpm_array_max = 10;
unsigned char cpm_array[AVERAGE_MIN];
//current index for array
int cpm_index=0;
int first_touch_index=0;

//for calc
float cpm=0;
float uSv=0;
float peak_uSv=0;
int cnt=0;
float offset_usv=0;
float carib_cpm0=-1;
float carib_usv0=-1;
float carib_cpm1=-1;
float carib_usv1=-1;

//for long term average
unsigned int long_cpm_array_max = 60;
unsigned int *long_cpm_array;
int long_cpm_index=0;
int long_first_touch_index=0;
unsigned char count_second=0;
float long_cpm=0;
float long_uSv=0;


//for setting (config_env.c)
float carib=660;
int console_output_flag=0;
int updateinterval=10;
int updateintervalcount=0;
int updateflag=0; /* 0: Standalone 1: Twitter 2:Pachube */
int updatetype=0;  /* 0: no 1: twitter 2: pachube */
int sound=0;    /* 0: off  1: on */
float voltagedivider=500; /* voltage_divider of the voltage by the board */
float volt=400; /* voltage executed to GM tube */
int firmware_update_interval=24;
time_t tz_offset=9;
char fwserver[256];
int init_stabilize_time=30;
int cpu_speed=12;    // 12=96MHz

// Ethernet
EthernetNetIf eth;
Ethernet eth0;
NTPClient ntp;


// File access
LocalFileSystem local("local");

// Output display selection
int LCD_writing=0;

//buzzer
Timeout click;

HTTPClient commonClient;
