/****************************************
* Firmware Updater *

*****************************************/

#include "mbed.h"
#include "FirmwareUpdater.h"
#include "TextLCD.h"

extern TextLCD  lcd;
extern FirmwareUpdater *fwup;

void check_newfirm() {
    int fwupret;
    string getname;
    
    lcd.cls();
    getname = fwup->getName();
    lcd.printf("Cheking update.");
    fwupret = fwup->exist();
    
    lcd.cls();lcd.locate(0,0);
    switch (fwupret) {
    case 0:
        lcd.printf("Found new firmware.\nUpdateing.");
        int execret = fwup->execute();

        lcd.cls();lcd.locate(0,0);
        switch (execret) {
        case 0:
            lcd.printf("Update succeed.\n");
            lcd.printf("Resetting.\n");
            wait(5);
            fwup->reset();
            break;
        case -1:
            lcd.printf("Can't get %s.txt", getname.c_str());
            break;
        case -2:
            lcd.printf("Can't get %s.bin", getname.c_str());
            break;
        case -8:
            lcd.printf("Can't get %s.md5", getname.c_str());
            break;
        case -3:
            lcd.printf("Can't read local/%s.txt", getname.c_str());
            break;
        case -4:
            lcd.printf("Can't read new %s.txt", getname.c_str());
            break;
        case -5:
            lcd.printf("local is new,server is old", getname.c_str());
            break;
        case -9:
            lcd.printf("Can't read new %s.md5", getname.c_str());
            break;
        case -10:
            lcd.printf("Can't read new %s.bin", getname.c_str());
            break;
        case -11:
            lcd.printf("MD5 checksum error", getname.c_str());
            break;
        }
        break;
    case -1:
        lcd.printf("%s%s error.\n", getname.c_str(),".txt");
        break;
    case -2:
        lcd.printf("F/W server error.\n");
        break;
    case 1:
        lcd.printf("no update found.\n");
        break;
    }
    wait(2);
}
