/*************************************************************

 History
 2011/08/23 - Add nsvlong0,cpmlong0.
 2011/08/03 - variable stream number.


*************************************************************/
/**
 * =============================================================================
 * Application configuration for 'Expansion Board One' example no.2
 * http://mbed.org/users/shintamainjp/notebook/starboard_expbrd-one_ex2_en/
 * =============================================================================
 * Copyright (c) 2010 Shinichiro Nakamura (CuBeatSystems)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * =============================================================================
 */

#include "appconf.h"
#include "ConfigFile.h"

#define KEY_PACHUBE_APIKEY   "PACHUBE_APIKEY"
#define KEY_PACHUBE_FEEDID   "PACHUBE_FEEDID"
#define KEY_STREAM_NSV0      "nsv0"      //  2011/08/03
#define KEY_STREAM_CPM0      "cpm0"      //  2011/08/03
#ifdef DUALGM
#define KEY_STREAM_NSV1      "nsv1"      //  2011/08/03
#define KEY_STREAM_CPM1      "cpm1"      //  2011/08/03
#endif
#define KEY_STREAM_NSVLONG0   "nsvlong0"   //  2011/08/23
#define KEY_STREAM_CPMLONG0   "cpmlong0"   //  2011/08/23

//#define KEY_PACHUBE_INTERVAL "PACHUBE_INTERVAL"

/**
 * Initialize configuration.
 *
 * @param p A pointer to a application config.
 */
void appconf_init(appconf_t *p) {
    memset(p->apikey, 0, sizeof(p->apikey));
    memset(p->feedid, 0, sizeof(p->feedid));
    p->stream_nsv0 = -1; //default value 2011/08/03
    p->stream_cpm0 = -1; //default value 2011/08/03
#ifdef DUALGM
    p->stream_nsv1 = 2; //default value 2011/08/03
    p->stream_cpm1 = 3; //default value 2011/08/03
#endif
    p->stream_nsvlong0 = 0; //default value 2011/08/23
    p->stream_cpmlong0 = 1; //default value 2011/08/23

//    p->interval = 0;
}

/**
 * Read configuration.
 *
 * @param filename Filename.
 * @param p A pointer to a application config.
 * @return Return zero if it succeed.
 */
int appconf_read(char *filename, appconf_t *p) {
    ConfigFile cf;
    if (!cf.read(filename)) {
        return -1;
    }
    if (!cf.getValue(KEY_PACHUBE_APIKEY, p->apikey, sizeof(p->apikey))) {
        return -2;
    }    
    if (!cf.getValue(KEY_PACHUBE_FEEDID, p->feedid, sizeof(p->feedid))) {
        return -3;
    }
/*
    char buf[64];
    if (!cf.getValue(KEY_PACHUBE_INTERVAL, buf, sizeof(buf))) {
        return -4;
    } else {
        if (sscanf(buf, "%d", &(p->interval)) != 1) {
            return -5;
        }
    }
*/
// 2011/08/03 begin
    char buf[64];
    if(cf.getValue(KEY_STREAM_NSV0, buf, sizeof(buf))) {
      if(sscanf(buf, "%d", &(p->stream_nsv0)) !=1) {
        return -5;
      }
   }

    if(cf.getValue(KEY_STREAM_CPM0, buf, sizeof(buf))) {
      if(sscanf(buf, "%d", &(p->stream_cpm0)) !=1) {
        return -6;
      }
   }
#ifdef DUALGM
    if(cf.getValue(KEY_STREAM_NSV1, buf, sizeof(buf))) {
      if(sscanf(buf, "%d", &(p->stream_nsv1)) !=1) {
        return -7;
      }
   }

    if(cf.getValue(KEY_STREAM_CPM1, buf, sizeof(buf))) {
      if(sscanf(buf, "%d", &(p->stream_cpm1)) !=1) {
        return -8;
      }
   }
#endif
// 2011/08/03 end
    if(cf.getValue(KEY_STREAM_NSVLONG0, buf, sizeof(buf))) {     //  2011/08/23
      if(sscanf(buf, "%d", &(p->stream_nsvlong0)) !=1) {         //  2011/08/23
        return -9;                                              //  2011/08/23
      }                                                         //  2011/08/23
   }                                                            //  2011/08/23
    if(cf.getValue(KEY_STREAM_CPMLONG0, buf, sizeof(buf))) {     //  2011/08/23
      if(sscanf(buf, "%d", &(p->stream_cpmlong0)) !=1) {         //  2011/08/23
        return -10;                                              //  2011/08/23
      }                                                         //  2011/08/23
   }                                                            //  2011/08/23
    return 0;
}

/**
 * Write configuration.
 *
 * @param filename Filename.
 * @param p A pointer to a application config.
 * @return Return zero if it succeed.
 */
int appconf_write(char *filename, appconf_t *p) {
    ConfigFile cf;
    if (!cf.setValue(KEY_PACHUBE_APIKEY, p->apikey)) {
        return -1;
    }
    if (!cf.setValue(KEY_PACHUBE_FEEDID, p->feedid)) {
        return -2;
    }
/*
    char buf[64];
    snprintf(buf, sizeof(buf) - 1, "%d", p->interval);
    if (!cf.setValue(KEY_PACHUBE_INTERVAL, buf)) {
        return -3;
    }
*/
    if (!cf.write(filename)) {
        return -4;
    }
    return 0;
}
