/*******************************************************************************
modify 
2011/08
        - Use commonClient.

*******************************************************************************/

/**
 * Pachube API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#ifndef _PACHUBE_V2_CSV_H_
#define _PACHUBE_V2_CSV_H_

#include "Pachube.h"
#include "HTTPClient.h"

class PachubeV2CSV : public Pachube {
public:

    explicit PachubeV2CSV(std::string APIKEY);

    virtual ~PachubeV2CSV();

    /*
     * =================================================================
     *  Environments (feeds)
     * =================================================================
     */

    /**
     * List all available feeds: GET /v2/feeds
     *
     * @param page Integer indicating which page of results you are requesting.
     * @param per_page Integer defining how many results to return per page (1 to 1000).
     * @param content String parameter ('full' or 'summary') describing whether we want full or summary results. Full results means all datastream values are returned, summary just returns the environment meta data for each feed.
     * @param q Full text search parameter. Should return any feeds matching this string.
     * @param tag Returns feeds containing datastreams tagged with the search query.
     * @param user Returns feeds created by the user specified.
     * @param units Returns feeds containing datastreams with units specified by the search query.
     * @param status Possible values ('live', 'frozen', or 'all'). Whether to search for only live feeds, only frozen feeds, or all feeds. Defaults to all.
     * @param order Order of returned feeds. Possible values ('created_at', 'retrieved_at', or 'relevance').
     */
    virtual int listAllAvailableFeeds(
        int page,
        int per_page,
        std::string content,
        std::string q,
        std::string tag,
        std::string user,
        std::string units,
        std::string status,
        std::string order,
        std::string &datatext);

    /**
     * Create new feed: POST /v2/feeds
     */
    virtual int createNewFeed(void);

    /**
     * Read feed: GET /v2/feeds/<feed_id>
     */
    virtual int readFeed(int feed_id, std::string &datatext);

    /**
     * Update feed: PUT /v2/feeds/<feed_id>
     */
    virtual int updateFeed(int feed_id);

    /**
     * Delete feed: DELETE /v2/feeds/<feed_id>
     */
    virtual int deleteFeed(int feed_id);

    /*
     * =================================================================
     *  Datastreams
     * =================================================================
     */

    /**
     * Create new datastream: POST /v2/feeds/<feed_id>/datastreams
     *
     * @param feed_id Feed ID.
     * @param stream_id Stream ID text.
     * @param value value.
     *
     * @return Return code from a web server.
     */
    virtual int createNewDataStream(int feed_id, std::string stream_id, std::string value);

    /**
     * Read datastream - GET /v2/feeds/<feed_id>/datastreams/<datastream_id>
     *
     * @param feed_id Feed ID.
     * @param stream_id Stream ID text.
     *
     * @return Return code from a web server.
     */
    virtual int readDataStream(int feed_id, std::string stream_id, std::string &datatext);

    /**
     * Update datastream: PUT /v2/feeds/<feed_id>/datastreams/<datastream_id>
     *
     * @param feed_id Feed ID.
     * @param stream_id Stream ID text.
     * @param value value.
     *
     * @return Return code from a web server.
     */
//    virtual int updateDataStream(int feed_id, std::string stream_id, std::string value);
    virtual int updateDataStream(int feed_id, std::string stream_id, std::string value, HTTPClient *pClient);   //  2011/08

    /**
     * Delete datastream: DELETE /v2/feeds/<feed_id>/datastreams/<datastream_id>
     *
     * @param feed_id Feed ID.
     * @param stream_id Stream ID text.
     *
     * @return Return code from a web server.
     */
    virtual int deleteDataStream(int feed_id, std::string stream_id);

};

#endif
