/***********************************

 twitter.c

***********************************/
#include "mbed.h"
#include "HTTPClient.h"
#include "TextLCD.h"

#define DEBUG

//LCD
extern TextLCD lcd;
extern HTTPClient commonClient;

extern void printable_msg(char*);
extern int GetStatus(char *, char *, char *);

char id[128];
char password[128];

/**************************************
* Output to Twitter *
***************************************/
void twitter_output(void){
    char msg[256];
    msg[0]='\0';
    printable_msg(msg);

    HTTPMap h_msg;
    h_msg["status"] = msg; //A good example of Key/Value pair use with Web APIs

    commonClient.basicAuth(id, password);   //We use basic authentication, replace with you account's parameters
#ifdef DEBUG
//  printf("twitter\r\n");
  printf("%s,%s\r\n",id,password);
#endif
    //No need to retieve data sent back by the server
    HTTPResult r = commonClient.post("http://api.supertweet.net/1/statuses/update.xml", h_msg, NULL);

#ifdef DEBUG
    if( r == HTTP_OK ){
        printf("%s",msg);
        printf("Tweet sent with success!\n");
    }else{
        printf("Problem during tweeting, return code %d\n", r);
    }
#endif
}

void twitter_setup(){
    GetStatus("/local/TWITTER.CFG","ID",id);
    GetStatus("/local/TWITTER.CFG","PASS",password);
    printf("twitter ID=%s, password=%s\r\n",id,password);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Twitter ID=%s",id);
    wait(2);
}


