/*************************************************************

 display.c

*************************************************************/
#include "mbed.h"
#include "TextLCD.h"
#include "GPS.h"
#include "NTPClient.h"

extern void calculate_sv();
extern float cpm;
extern float uSv;
extern int LCD_writing;
extern GPS* gps;
extern TextLCD lcd;
extern NTPResult ntpRet;
extern time_t tz_offset;

void debug_print()
{

    calculate_sv();
#ifdef DEBUG
    printf("cpm=%3.2f, %3.2fuSv/h\r\n",cpm,uSv);
    for(int i=0;i<first_touch_index;i++){
        printf("[%d]=%f\r\n",i,cpm_array[i]);
    }
    printf("first_touch_index=%d\r\n",first_touch_index);
    printf("cpm_index=%d\r\n",cpm_index);
#endif
}

/**************************************
* calendar hyoji
***************************************/
void calendarHyoji(char *msg){
    time_t ctTime;
    struct tm *jst_time;
    char tmp[100] = "\0";
    
    ctTime = time(NULL);
    ctTime += tz_offset;
    jst_time = localtime(&ctTime);
    
    sprintf(tmp,"%4d/%02d/%02d %02d:%02d",
                jst_time->tm_year+1900,
                (jst_time->tm_mon + 1),
                jst_time->tm_mday, 
                jst_time->tm_hour, 
                jst_time->tm_min);
    strcat(msg, tmp);    
}
/**************************************
* fullcalendar hyoji
***************************************/
void fullcalendarHyoji(char *msg){
    time_t ctTime;
    struct tm *jst_time;
    char tmp[100];
    tmp[0] = '\0';
    
    ctTime = time(NULL);
    ctTime += tz_offset;
    jst_time = localtime(&ctTime);
    
    sprintf(tmp,"%4d/%02d/%02d,%02d:%02d:%02d,",jst_time->tm_year+1900,(jst_time->tm_mon + 1),jst_time->tm_mday, jst_time->tm_hour, jst_time->tm_min, jst_time->tm_sec);
    strcat(msg, tmp);    
}

void LCD_out_sub(){
    calculate_sv(); 
    lcd.printf("\n%3dcpm/",((int)cpm < 1000 ? (int)cpm : 999));
    if (uSv < 10.0) {
        lcd.printf("%.3fuSv",uSv);
    } else if (uSv < 100.0) {
        lcd.printf("%.2fuSv",uSv);
    } else {
        lcd.printf("%.2fuSv",99.99);
    }
}


/**************************************
* LCD output kiokuchi wo LCD ni hyoji
***************************************/
void LCD_output(){
    if(LCD_writing){
        return;
    }    
    LCD_writing=1;
    LCD_out_sub();
    LCD_writing=0;
}


void LCD_time_and_output(){
    char msg[256];
    msg[0]='\0';

    if(LCD_writing){
        return;
    }    
    LCD_writing=1;
    lcd.cls();
    lcd.locate(0,0);

    if ( ntpRet == NTP_OK) {
      calendarHyoji(msg);
    }
    lcd.printf("%s",msg);
    lcd.locate(0,0);
    LCD_out_sub();
    LCD_writing=0;
}

void LCD_cpm_output() {
   if(LCD_writing){
     return;
   }    
   LCD_writing=1;
   lcd.cls();
   lcd.locate(0,0);
   calculate_sv(); 
   lcd.printf("GM check mode\n%.3fcpm",cpm);
   LCD_writing=0;
}

void printable_msg(char* msg){
    char tmp[256];
    tmp[0]= '\0';
   
    if(gps->longitude!=0 && gps->latitude!=0)
        sprintf(msg,"%f,%f:",gps->longitude,gps->latitude);
    
    calculate_sv(); 
 
    fullcalendarHyoji(tmp);
    strcat(msg,tmp);
    
    strcat(msg," ");
    sprintf(tmp,"%d",(int)cpm);
    strcat(msg,tmp);
    strcat(msg,"cpm,");
    sprintf(tmp,"%.3f",uSv);
    strcat(msg,tmp);
    strcat(msg,"uSv\n");

}

