/*******************************************************************************
modify 
2011/08
        - Use commonClient.

*******************************************************************************/

/**
 * Pachube API interface driver. (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#include "PachubeV2CSV.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

PachubeV2CSV::PachubeV2CSV(std::string APIKEY) : Pachube(APIKEY) {
}

PachubeV2CSV::~PachubeV2CSV() {
}

/*
 * =================================================================
 *  Environments (feeds)
 * =================================================================
 */

/**
 * List all available feeds: GET /v2/feeds
 */
int PachubeV2CSV::listAllAvailableFeeds(
        int page,
        int per_page,
        std::string content,
        std::string q,
        std::string tag,
        std::string user,
        std::string units,
        std::string status,
        std::string order,
        std::string &datatext) {
    HTTPClient client;
    client.setRequestHeader(Pachube::REQUESTHEADER, APIKEY);

    HTTPText text("text/csv");
    text.set("");
    HTTPText data;
    
    /*
     * Example: http://api.pachube.com/v2/feeds
     */
    char tmp[32];
    sprintf(tmp, "?page=%d&per_page=%d", page, per_page);
    string URL = Pachube::URLBASE_V2 + "/feeds.csv" + std::string(tmp);
    
    if (content.length() > 0) {
        URL = URL + "&content=" + content;
    }
    if (q.length() > 0) {
        URL = URL + "&q=" + q;
    }
    if (tag.length() > 0) {
        URL = URL + "&tag=" + tag;
    }
    if (user.length() > 0) {
        URL = URL + "&user=" + user;
    }
    if (units.length() > 0) {
        URL = URL + "&units=" + units;
    }
    if (status.length() > 0) {
        URL = URL + "&status=" + status;
    }
    if (order.length() > 0) {
        URL = URL + "&order=" + order;
    }

    HTTPResult result = client.get(URL.c_str(), &data);
    datatext = data.get();
    
    return client.getHTTPResponseCode();
}

/**
 * Create new feed: POST /v2/feeds
 */
int PachubeV2CSV::createNewFeed(void) {
    error("CSV is not supported for creating Environments because it cannot represent the required parameters due to its very simple format.");
    return 404;
}

/**
 * Read feed: GET /v2/feeds/<feed_id>
 */
int PachubeV2CSV::readFeed(int feed_id, std::string &datatext) {
    HTTPClient client;
    client.setRequestHeader(Pachube::REQUESTHEADER, APIKEY);

    HTTPText text("text/csv");
    text.set("");
    HTTPText data;

    /*
     * Example: http://api.pachube.com/v2/feeds/1977
     */
    char feed_id_char[32];
    sprintf(feed_id_char, "%d", feed_id);
    const string URL = Pachube::URLBASE_V2 + "/feeds/" + std::string(feed_id_char) + ".csv";

    HTTPResult result = client.get(URL.c_str(), &data);
    datatext = data.get();
    return client.getHTTPResponseCode();
}

/**
 * Update feed: PUT /v2/feeds/<feed_id>
 */
int PachubeV2CSV::updateFeed(int feed_id) {
    HTTPClient client;
    client.setRequestHeader(Pachube::REQUESTHEADER, APIKEY);

    HTTPText text("text/csv");
    text.set("");

    /*
     * Example: http://api.pachube.com/v2/feeds/1977?_method=put
     */
    char feed_id_char[32];
    sprintf(feed_id_char, "%d", feed_id);
    const string URL = Pachube::URLBASE_V2 + "/feeds/" + std::string(feed_id_char) + "?_method=put";

    HTTPResult result = client.post(URL.c_str(), text, NULL);
    return client.getHTTPResponseCode();
}

/**
 * Delete feed: DELETE /v2/feeds/<feed_id>
 */
int PachubeV2CSV::deleteFeed(int feed_id) {
    HTTPClient client;
    client.setRequestHeader(Pachube::REQUESTHEADER, APIKEY);

    HTTPText text("text/csv");
    text.set("");

    /*
     * Example: http://api.pachube.com/v2/feeds/1977?_method=delete
     */
    char feed_id_char[32];
    sprintf(feed_id_char, "%d", feed_id);
    const string URL = Pachube::URLBASE_V2 + "/feeds/" + std::string(feed_id_char) + "?_method=delete";

    HTTPResult result = client.post(URL.c_str(), text, NULL);
    return client.getHTTPResponseCode();
}

/*
 * =================================================================
 *  Datastreams
 * =================================================================
 */

/**
 * Create new datastream: POST /v2/feeds/<feed_id>/datastreams
 *
 * @param feed_id Feed ID.
 * @param stream_id Stream ID text.
 * @param value value.
 *
 * @return Return code from a web server.
 */
int PachubeV2CSV::createNewDataStream(int feed_id, std::string stream_id, std::string value) {
    HTTPClient client;
    client.setRequestHeader(Pachube::REQUESTHEADER, APIKEY);

    std::string data = stream_id + "," + value;
    HTTPText text("text/csv");
    text.set(data);

    /*
     * Example: http://api.pachube.com/v2/feeds/1977/datastreams
     */
    char feed_id_char[32];
    sprintf(feed_id_char, "%d", feed_id);
    const string URL = Pachube::URLBASE_V2 + "/feeds/" + std::string(feed_id_char) + "/datastreams";

    HTTPResult result = client.post(URL.c_str(), text, NULL);
    return client.getHTTPResponseCode();
}

/**
 * Read datastream - GET /v2/feeds/<feed_id>/datastreams/<datastream_id>
 *
 * @param feed_id Feed ID.
 * @param stream_id Stream ID text.
 *
 * @return Return code from a web server.
 */
int PachubeV2CSV::readDataStream(int feed_id, std::string stream_id, std::string &datatext) {
    HTTPClient client;
    client.setRequestHeader(Pachube::REQUESTHEADER, APIKEY);

    HTTPText text("text/csv");
    text.set("");
    HTTPText data;

    /*
     * Example: http://api.pachube.com/v2/feeds/1977/datastreams/energy
     */
    char feed_id_char[32];
    sprintf(feed_id_char, "%d", feed_id);
    const string URL = Pachube::URLBASE_V2 + "/feeds/" + std::string(feed_id_char) + "/datastreams/" + stream_id + ".csv";

    HTTPResult result = client.get(URL.c_str(), &data);
    datatext = data.get();
    return client.getHTTPResponseCode();
}

/**
 * Update datastream: PUT /v2/feeds/<feed_id>/datastreams/<datastream_id>
 *
 * @param feed_id Feed ID.
 * @param stream_id Stream ID text.
 * @param value value.
 *
 * @return Return code from a web server.
 */
//int PachubeV2CSV::updateDataStream(int feed_id, std::string stream_id, std::string value) {
int PachubeV2CSV::updateDataStream(int feed_id, std::string stream_id, std::string value, HTTPClient *client) { //  2011/08
    //HTTPClient client;
    client->setRequestHeader(Pachube::REQUESTHEADER, APIKEY);   //  2011/08

    HTTPText text("text/csv");
    text.set(value);

    /*
     * Example: http://api.pachube.com/v2/feeds/1977/datastreams/energy?_method=put
     */
    char feed_id_char[32];
    sprintf(feed_id_char, "%d", feed_id);
    const string URL = Pachube::URLBASE_V2 + "/feeds/" + std::string(feed_id_char) + "/datastreams/" + stream_id + "?_method=put";
    HTTPResult result = client->post(URL.c_str(), text, NULL);
    return client->getHTTPResponseCode();   // 2011/08
}

/**
 * Delete datastream: DELETE /v2/feeds/<feed_id>/datastreams/<datastream_id>
 *
 * @param feed_id Feed ID.
 * @param stream_id Stream ID text.
 *
 * @return Return code from a web server.
 */
int PachubeV2CSV::deleteDataStream(int feed_id, std::string stream_id) {
    HTTPClient client;
    client.setRequestHeader(Pachube::REQUESTHEADER, APIKEY);

    HTTPText text("text/csv");
    text.set("");

    /*
     * Example: http://api.pachube.com/v2/feeds/1977/datastreams/energy?_method=delete
     */
    char feed_id_char[32];
    sprintf(feed_id_char, "%d", feed_id);
    const string URL = Pachube::URLBASE_V2 + "/feeds/" + std::string(feed_id_char) + "/datastreams/" + stream_id + "?_method=delete";

    HTTPResult result = client.post(URL.c_str(), text, NULL);
    return client.getHTTPResponseCode();
}
