#ifndef __PN532_H__
#define __PN532_H__

#define PN532_PREAMBLE 0x00
#define PN532_STARTCODE1 0x00
#define PN532_STARTCODE2 0xFF
#define PN532_POSTAMBLE 0x00

#define PN532_HOSTTOPN532 0xD4

#define PN532_FIRMWAREVERSION 0x02
#define PN532_GETGENERALSTATUS 0x04
#define PN532_SAMCONFIGURATION  0x14
#define PN532_INLISTPASSIVETARGET 0x4A
#define PN532_INDATAEXCHANGE 0x40
#define PN532_INJUMPFORDEP 0x56
#define PN532_TGINITASTARGET 0x8C
#define PN532_TGGETDATA 0x86
#define PN532_TGSETDATA 0x8E



#define PN532_WAKEUP 0x55
#define  PN532_SPI_STATREAD  0x02
#define  PN532_SPI_DATAWRITE 0x01
#define  PN532_SPI_DATAREAD  0x03
#define  PN532_SPI_READY  0x01

#define PN532_MIFARE_ISO14443A 0x0

#define KEY_A   1
#define KEY_B   2

#define mosi1 p5
#define miso1 p6
#define sclk1 p7
#define ss1 p8

#define REVERSE_BITS_ORDER(b)         b = (b & 0xF0) >> 4 | (b & 0x0F) << 4; \
    b = (b & 0xCC) >> 2 | (b & 0x33) << 2; \
    b = (b & 0xAA) >> 1 | (b & 0x55) << 1

class PN532
{
public:
  
  PN532(PinName mosi, PinName miso, PinName sclk, PinName ss);
  void begin(void);         
  bool SAMConfig(void);
  uint32_t getFirmwareVersion(void);
  uint32_t configurePeerAsInitiator(void);
  uint32_t configurePeerAsTarget(void);
  bool initiatorTxRx(char* dataOut, char* dataIn); 
  uint32_t targetTxRx(char* dataOut, char* dataIn);
  bool sendCommandCheckAck(uint8_t *cmd, uint8_t cmdlen, uint16_t timeout = 1000);
  
private:
  DigitalOut *_ss;   
  SPI *_spi;
  
  uint8_t read(uint8_t buff[], uint8_t n);
  uint8_t readSpiStatus(void);
  bool checkSpiAck(void);
  void writeCommand(uint8_t buf[], uint8_t len);
  void wakeup (void);
    inline void write(uint8_t data) {
        REVERSE_BITS_ORDER(data);
        _spi->write(data);
    }
  inline uint8_t read() {
        uint8_t data =  _spi->write(0);
        REVERSE_BITS_ORDER(data);
        return data;
    }
  
  
};

#endif