#include "mbed.h"
#include "PN532.h"
#include <string>


DigitalOut led1(LED1);
DigitalOut led2 (LED2);


PN532 nfc(mosi1, miso1, sclk1, ss1);

int main()
{
    printf("\r INITIATOR STARTED\n");
    nfc.begin();


    uint32_t versiondata = nfc.getFirmwareVersion();
    if (! versiondata) {
        printf("Didn't find PN532\r\n");

        while (1) {
            led1 = !led1;
            wait(0.1);
        }
    }

    printf("Found chip PN5%2X\r\n", versiondata >> 24);
    printf("Firmware V%d.%d\r\n", (versiondata >> 16) & 0xFF, (versiondata >> 8) & 0xFF);


    nfc.SAMConfig();
    wait(1);

    char dataOut[] = "hello target";
    char dataIn[16];
   
    while (1) {
        if(nfc.configurePeerAsInitiator()==1) {
            printf("found target");
            nfc.initiatorTxRx(dataOut, dataIn);
            printf("\n\r%s", dataIn);
        } else {
            printf("no target");
        }
        led1=!led1;
        wait(1);
    }
}

