#include "mbed.h"
#include "csv_parser.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include <map>
#include <iostream>

SDFileSystem sd(p5, p6, p7, p8, "sd");
TextLCD lcd(p24, p26, p27, p28, p29, p30);

using namespace std;

int main()
{
    map<string,string> names;
    
    csv_parser csv;
    csv.init("/sd/mydir/koi.csv");
    
    while(csv.has_more_rows()){
        csv_row row = csv.get_row();
        names.insert( make_pair( row[0] , row[1] ) );
    }
    
    for(;;){
        string str;
        cin >> str;
        if( str == "exit" ) break;
        
        lcd.cls();
        lcd.printf( names[str].c_str() );
    }
}