#include "mbed.h"

Serial pc(USBTX, USBRX);
DigitalOut myled1(LED1), myled2(LED2);
AnalogIn LM61(p15);

char program_name[128] = "Serial IO";

int main()
{
    pc.printf("run: %s\n", program_name);
    float temp, tempC, tempF;
    while(1) {
        temp = LM61;
        tempC = ((temp*3.3)-0.600)*100.0;
        //convert to degrees F
        tempF = (9.0*tempC)/5.0 + 32.0;
        //print current temp
        printf("%5.2F : %5.2F C %5.2F F \n\r", temp, tempC, tempF);
        wait(2);

    }
}
