/*
* G3: WATERPLAY
*/

#include "TemperatureSensor.h"
#include <algorithm>
#include "mbed.h"

TemperatureSensor::TemperatureSensor(
    Printer &printer,
    PinName pin
):
    _printer(printer),
    _analog_in(pin),
    _reading(0.0),
    _voltage(0.0),
    _temperature(0.0),
    _status(0.0),
    _strStatus("OK"),
    _in_boundary(false)
{
    this->reload();
}

void TemperatureSensor::reload()
{
    double readings[SAMPLING_NUMBER];
    for(int counter = 0; counter < SAMPLING_NUMBER; ++counter){
        readings[counter] = _analog_in.read();
    }
    
    sort(readings, readings + SAMPLING_NUMBER);
    
    this->_reading = readings[SAMPLING_NUMBER / 2];
    this->_voltage = this->_reading * VIN * CONVERTER;
    double RT = (this->_voltage * RESISTANCE) / (VIN - this->_voltage);
    double logRT = log(RT);
    double k0 = K0; 
    double k1 = K1 * logRT;
    double k2 = K2 * pow(logRT, 3.0);
    double kelvin = 1.0 / (k0 + k1 + k2);
    this->_temperature = (kelvin + KELVIN_TO_CELCIUS);
    
    if(this->_temperature > KELVIN_TO_CELCIUS){
        this->_temperature += VARIANCE;
        this->_temperature += 0.21*this->_temperature - 6.09;
    }
    
    this->_in_boundary = false;
    if(this->_temperature > 0.0 && this->_temperature < 100.0){
        this->_in_boundary = true;
    }
    
    this->_status = 0.0;
    this->_strStatus = "OK";
    if(this->_temperature < LOWER_BOUNDARY){
        this->_status = this->_temperature - LOWER_BOUNDARY;
        this->_strStatus = "LW";
    } else if(this->_temperature > UPPER_BOUNDARY){
        this->_status = this->_temperature - UPPER_BOUNDARY;
        this->_strStatus = "HI";
    }
    
    this->_in_boundary = false;
    if(this->_temperature > 0.0 && this->_temperature < 100.0){
        this->_in_boundary = true;
    }
}

double TemperatureSensor::getReading()
{
    return(this->_reading);
}


double TemperatureSensor::getVoltage()
{
    return(this->_voltage);
}

double TemperatureSensor::getTemperature()
{
    return(this->_temperature);
}

double TemperatureSensor::getStatus()
{
    return(this->_status);
}

char* TemperatureSensor::getStrStatus()
{
    return(this->_strStatus);
}

bool TemperatureSensor::inBoundary(){
    return(this->_in_boundary);
}

bool TemperatureSensor::inDanger(){
    bool in_danger = false;
    if(this->_in_boundary && this->_status != 0.0){
        in_danger = true;
    }
    return(in_danger);
}