/*
* G3: WATERPLAY
*/

#ifndef TANK_H
#define TANK_H

#include "DRV8825.h"
#include "Flasher.h"
#include "Ping.h"
#include "Printer.h"
#include "mbed.h"

class Tank
{
public:
    Tank(
        Printer &printer,
        DRV8825 &salinitySyringe,
        DRV8825 &waterSyringe,
        Ping &pinger,
        Flasher &alarm
    );
    static const int DIRECTION_PULL = 1;
    static const int DIRECTION_PUSH = 0;
    static const int TYPE_SALT = 1;
    static const int TYPE_PURE = 0;
    static const int POSITION_MAX = 35;
    static const int POSITION_MIN = 0;
    static const int MAX_SPEED = 8000;
    static const int MICROSTEPS_PER_STEP = 32;
    static const int MOVEMENT = 4600;
    static const int STEP_EXTRA = 3000;
    static const float ADDED_SALT = 15.0;
    static const float ADDED_WATER = 15.0;
    static const int PROXIMITY_CHECK_POINT = 100;
    void add(int type, int mililiters, int direction);
    void react(double salinity);
    bool is_proximity_ok();
    char* getStrStatus();
    void initialize();

private:
    Printer &_printer;
    DRV8825 &_salinitySyringe;
    DRV8825 &_waterSyringe;
    Ping &_pinger;
    Flasher &_alarm;
    int _status;
    char* _strStatus;
    int _previous_direction_salt;
    int _previous_direction_pure;
    int _position_salt;
    int _position_pure;
    float _added_liquid;
};

#endif