/*
* G3: WATERPLAY
*/

#include "Printer.h"
#include "Tank.h"
#include "mbed.h"

Tank::Tank(
    Printer &printer,
    DRV8825 &salinitySyringe,
    DRV8825 &waterSyringe,
    Ping &pinger,
    Flasher &alarm
):
    _printer(printer),
    _salinitySyringe(salinitySyringe),
    _waterSyringe(waterSyringe),
    _pinger(pinger),
    _alarm(alarm),
    _strStatus("Add nothing"),
    _previous_direction_salt(-1),
    _previous_direction_pure(-1),
    _position_salt(14),
    _position_pure(27),
    _added_liquid(0.0)
{
}

char* Tank::getStrStatus()
{
    return (this->_strStatus);
}

bool Tank::is_proximity_ok()
{
    int range = 0;
    char buffer[32];

    _pinger.Send();
    wait(0.1);
    range = _pinger.Read_cm();

    range = range/2;

    sprintf(
        buffer,
        "proximity is (%d cm)",
        range
    );
    _printer.toBothln(buffer);

    if (range >= 7) {
        return true;
    }

    return false;
}

void Tank::add(int type, int mililiters, int direction)
{
    for (int i = 25; i < MAX_SPEED; i+=20) {
        if (type == TYPE_SALT)
            _salinitySyringe.settings(1/MICROSTEPS_PER_STEP, direction, i);
        else
            _waterSyringe.settings(1/MICROSTEPS_PER_STEP, direction, i);
    }

    //fix the changing of directions for pure
    if (type == TYPE_PURE) {
        //mililiters = mililiters * 2.0;
        if (_previous_direction_pure != direction)
            mililiters = mililiters + 1.0;
    }

    //fix the changing of directions for salt
    if (type == TYPE_SALT) {
        //mililiters = mililiters * 2.0;
        if (_previous_direction_salt != direction)
            mililiters = mililiters + 1.0;
        //if (_previous_direction_salt == DIRECTION_PULL)
        //mililiters = mililiters + 0.5;
    }

    //move with constant speed
    for (int i = 1; i < (MOVEMENT + (int)floor(((mililiters - 1.0)*STEP_EXTRA))); i+=1) {
        if (type == TYPE_SALT)
            _salinitySyringe.settings(1/MICROSTEPS_PER_STEP, direction, MAX_SPEED);
        else
            _waterSyringe.settings(1/MICROSTEPS_PER_STEP, direction, MAX_SPEED);

        //if ((i - MOVEMENT) % STEP_EXTRA == 0 && !proximity_ok())
        //  break;
    }

    //de-accelerate
    for (int i = MAX_SPEED; i > 0; i-=20) {
        if (type == TYPE_SALT)
            _salinitySyringe.settings(1/MICROSTEPS_PER_STEP, direction, i);
        else
            _waterSyringe.settings(1/MICROSTEPS_PER_STEP, direction, i);
    }

    //remember previous direction
    if (type == TYPE_SALT) {
        _previous_direction_salt = direction;
    } else {
        _previous_direction_pure = direction;
    }
}
void Tank::react(double salinity)
{
    _strStatus = "Add nothing";
    float added_liquid = 0.0;
    
    if(is_proximity_ok()) {
        if(salinity < 0.0) {
            _strStatus = "Add salt";
            _printer.toBothln("set salt valve to the tank");
            _alarm.salinity_flash();
            this->add(TYPE_SALT, ADDED_SALT, DIRECTION_PUSH);
            _printer.toBothln("set salt valve to the reservoir");
            _alarm.salinity_flash();
            this->add(TYPE_SALT, ADDED_SALT, DIRECTION_PULL);
            added_liquid = ADDED_SALT;
        } else if(salinity > 0.0) {
            _strStatus = "Add water";
            _printer.toBothln("set water valve to the tank");
            _alarm.water_flash();
            this->add(TYPE_PURE, ADDED_WATER, DIRECTION_PUSH);
            _printer.toBothln("set water valve to reservoir");
            _alarm.water_flash();
            this->add(TYPE_PURE, ADDED_WATER, DIRECTION_PULL);
            added_liquid = ADDED_WATER;
        }
        this->_added_liquid += added_liquid;
    } else {
        _strStatus = "Tank is overflowing";
        _alarm.danger_flash();
    }
}

void Tank::initialize()
{
    _printer.toBothln("initializing...");
    //initialize
    _alarm.water_flash(); //turn the thing to pulling from reservoir
    this->add(TYPE_PURE, 20.0, DIRECTION_PULL);//20
    _alarm.water_flash(); //turn the thing to pushing to glass
    this->add(TYPE_PURE, 20.0, DIRECTION_PUSH);//19.5
    _alarm.water_flash(); //turn the thing to pulling from reservoir
    this->add(TYPE_PURE, 20.0, DIRECTION_PULL); //20
    _alarm.water_flash(); //turn the thing to pushing to glass
    this->add(TYPE_PURE, 20.0, DIRECTION_PUSH);
    _alarm.water_flash(); //turn the thing to pulling from reservoir
    this->add(TYPE_PURE, 25.0, DIRECTION_PULL); //20
    //done

    //initialize
    _alarm.salinity_flash(); //turn the thing to pulling from reservoir
    this->add(TYPE_SALT, 20.0, DIRECTION_PULL);//20
    _alarm.salinity_flash(); //turn the thing to pushing to glass
    this->add(TYPE_SALT, 20.0, DIRECTION_PUSH);//19.5
    _alarm.salinity_flash(); //turn the thing to pulling from reservoir
    this->add(TYPE_SALT, 20.0, DIRECTION_PULL); //20
    _alarm.salinity_flash(); //turn the thing to pushing to glass
    this->add(TYPE_SALT, 20.0, DIRECTION_PUSH);
    _alarm.salinity_flash(); //turn the thing to pulling from reservoir
    this->add(TYPE_SALT, 25.0, DIRECTION_PULL); //20
}