#include "Flasher.h"
#include "mbed.h"

Flasher::Flasher(PinName pin) : _pin(pin)
{
    _pin = 0;
}

void Flasher::flash(int n)
{
    for(int i=0; i<n*2; i++) {
        _pin = !_pin;
        wait(0.2);
    }
}

void Flasher::flash(int n, float delay, float waiting_time)
{
    for(int i=0; i<n*2; i++) {
        _pin = !_pin;
        wait(delay);
    }
    wait(waiting_time);
}

void Flasher::danger_flash()
{
    this->flash(3, 0.3, 3.0);
}

void Flasher::danger_flash_long()
{
    this->flash(3, 0.3, 10.0);
}

void Flasher::water_flash()
{
    this->flash(1, 0.2, 3.0);
}

void Flasher::salinity_flash()
{
    this->flash(2, 0.2, 3.0);
}