/*
* G3: WATERPLAY
*/

#include "Waterplay.h"
#include "mbed.h"

Waterplay::Waterplay(
    Printer &printer,
    TemperatureSensor &temperatureSensor,
    SalinitySensor &salinitySensor,
    Thermostat &thermostat,
    Tank &tank,
    Flasher &flasher,
    Flasher &alarm
):
    _printer(printer),
    _temperatureSensor(temperatureSensor),
    _salinitySensor(salinitySensor),
    _thermostat(thermostat),
    _tank(tank),
    _flasher(flasher),
    _alarm(alarm)
{
}

int Waterplay::control()
{
    int retVal = 1;
    _temperatureSensor.reload();
    _salinitySensor.reload();
    _flasher.flash(0.1);

    _printer.display(
        _salinitySensor.getSalinity(),
        _salinitySensor.getStrStatus(),
        _temperatureSensor.getTemperature(),
        _temperatureSensor.getStrStatus()
    );
    _flasher.flash(2);
    
    if(
        !_temperatureSensor.inBoundary()
        || !_salinitySensor.inBoundary()
        || !_tank.is_proximity_ok()
    ){
        if(!_temperatureSensor.inBoundary()){
            _printer.toBothln("check the temperature sensor");
        }
        
        if(_salinitySensor.inBoundary()){
            _printer.toBothln("check the salinity sensor");
        }
        
        if(!_tank.is_proximity_ok()){
            _printer.toBothln("check the salinity sensor");
        }
         _alarm.danger_flash_long();
    }
        
    if(_temperatureSensor.inDanger()) {
        _thermostat.react(
            _temperatureSensor.getStatus()
        );
    }

    if(_salinitySensor.inDanger()) {
        _tank.react(
            _salinitySensor.getStatus()
        );
    }

    _printer.display(
        _tank.getStrStatus(),
        _thermostat.getStrStatus()
    );

    return(retVal);
}