/*
* G3: WATERPLAY
*/

#include "SalinitySensor.h"
#include "mbed.h"
#include <algorithm>
#include "Printer.h"

SalinitySensor::SalinitySensor(
    Printer &printer,
    PinName pin
):
    _printer(printer),
    _analog_in(pin),
    _reading(0.0),
    _voltage(0.0),
    _salinity(0.0),
    _status(0.0),
    _strStatus("OK"),
    _in_boundary(false),
    _in_danger(false)
{
    this->reload();
}

void SalinitySensor::reload()
{
    double readings[SAMPLING_NUMBER];
    
    for(int counter = 0; counter < SAMPLING_NUMBER; ++counter){
        // the reading from sensor.
        readings[counter] = this->_analog_in.read();
    }

    sort(readings, readings + SAMPLING_NUMBER);
    
    this->_reading = readings[SAMPLING_NUMBER / 2];
    
    // converted voltage.
    this->_voltage = 
        this->_reading *
        VIN *
        CONVERTER;
    // the salinity value.
    this->_salinity = 
        this->_voltage *
        MULTIPLIER;
    
    
    this->_in_boundary = false;
    if(this->_salinity > 0.25){
       this->_salinity += VARIANCE;
       this->_in_boundary = true;
    }
    this->_status = 0.0;
    this->_strStatus = "OK";
    if(this->_salinity < LOWER_BOUNDARY){
        this->_status = this->_salinity - LOWER_BOUNDARY;
        this->_strStatus = "LW";
    } else if(this->_salinity > UPPER_BOUNDARY){
        this->_status = this->_salinity - UPPER_BOUNDARY;
        this->_strStatus = "HI";
    }
}

double SalinitySensor::getReading()
{
    return(this->_reading);
}

double SalinitySensor::getVoltage()
{
    return(this->_voltage);
}

double SalinitySensor::getSalinity()
{
    return(this->_salinity);
}

double SalinitySensor::getStatus()
{
    return(this->_status);
}

char* SalinitySensor::getStrStatus()
{
    return(this->_strStatus);
}

bool SalinitySensor::inBoundary()
{
    return(this->_in_boundary);
}

bool SalinitySensor::inDanger()
{
    bool in_danger = false;
    if(this->_in_boundary && this->_salinity != 0.0){
        in_danger = true;
    }
    return(in_danger);
}