/*
* G3: WATERPLAY
*/

#include "Printer.h"
#include "TextLCD.h"
#include "mbed.h"

Printer::Printer(
    mbed::Serial &serial,
    TextLCD &lcd
):
    _serial(serial),
    _lcd(lcd),
    _serial_message("G3: WATERPLAY\n\r"),
    _lcd_message("G3: WATERPLAY\n"),
    _display_status(true),
    _display_action(false)
{
}
void Printer::switchStatus()
{
    _display_status = !_display_status;
}

void Printer::switchAction()
{
    _display_action = !_display_action;
}
void Printer::toSerial(char *message)
{
    this->_serial_message = message;
    this->display();
}
void Printer::toLCD(char *message)
{
    this->_lcd_message = message;
    this->display();
}
void Printer::toBoth(char *message)
{
    this->_serial_message = message;
    this->_lcd_message = message;
    this->display();
}
void Printer::toBothln(char *message)
{
    char serial_buffer[48];
    char lcd_buffer[48];
    sprintf(
        serial_buffer,
        "%s\n\r",
        message
    );

    sprintf(
        lcd_buffer,
        "%s\n",
        message
    );

    this->_serial_message = serial_buffer;
    this->_lcd_message = lcd_buffer;
    this->display();
}
void Printer::display()
{
    if(_display_action){
        this->_serial.printf(
            "%s",
            this->_serial_message
        );
    
        this->_lcd.cls();
        this->_lcd.printf(
            "%s",
            this->_lcd_message
        );
    }
}
void Printer::display(double salinity, char* salinityStatus, double temperature, char* temperatureStatus)
{
    if(_display_status){
        this->_serial.printf(
            "salinity: %3.2F (%s) || temperature: %3.2F (%s)\n\r",
            salinity,
            salinityStatus,
            temperature,
            temperatureStatus
    
        );
    
        this->_lcd.cls();
        this->_lcd.printf(
            "sal: %3.2F %s\ntmp: %3.2F %s\n",
            salinity,
            salinityStatus,
            temperature,
            temperatureStatus
        );
    }
}
void Printer::display(char* salinityStrStatus, char* temperatureStrStatus){
    if(_display_status){
        this->_serial.printf(
            "%s || %s\n\r",
            salinityStrStatus,
            temperatureStrStatus
        );
    
        this->_lcd.cls();
        this->_lcd.printf(
            "%s\n%s\n",
            salinityStrStatus,
            temperatureStrStatus
        );
    }
}
