/*
//#include "ssWi.hpp"
#include "ssWiSocket.hpp"
#include "ssWiPort.hpp"


ssWiChannel* ssWiSocket::channel = NULL;
Mutex ssWiSocket::chMutex = Mutex();

static Thread* ssWiSocket::sender = NULL;
static Thread* ssWiSocket::receiver = NULL;


static bool ssWiSocket::setChannel (ssWiChannel* c)
{
    if (sender!=NULL)
        delete sender;
    if (receiver!=NULL)
        delete receiver;
    chMutex.lock();
    channel = c;
    sender = new Thread(threadSender);
    receiver = new Thread(threadReceiver);
    chMutex.unlock();
}

ssWiSocket::ssWiSocket(PortID port)
{
    this->port = port;
    setPort (port);
}

bool ssWiSocket::valid ()
{
    return isActive(port);
}

bool ssWiSocket::close()
{
    return unsetPort(port);
}

bool ssWiSocket::read (PortValue &value)
{
    return readPort (port, value);
}

bool ssWiSocket::write (PortValue value)
{
    return writePort (port, value);
}


#include "ssWi.hpp"




#include "mbed.h"
#include "rtos.h"




bool setPort (PortID port)
{
    if (ports.find(port)!=ports.end())
        return false;
    ports[port];
    return true;
}

bool isActive (PortID port)
{
    return ports.find(port)!=ports.end();
}

bool unsetPort (PortID port)
{
    if (ports.find(port)==ports.end())
        return false;
    ports.erase(port);
    return true;
}

bool readPort (PortID port, PortValue &value)
{
    if (ports.find(port)==ports.end())
        return false;
    value = ports[port].getRXValue();
    return true;
}

bool writePort (PortID port, PortValue value)
{
    if (ports.find(port)==ports.end())
        return false;
    ports[port].setTXValue(value);
    return true;
}


#define INTERNAL_BUFFER_SIZE 100

void threadSender (void const* arg)
{
    char buffer[INTERNAL_BUFFER_SIZE];
    while(true) {
        int n = 0;
        std::map<int, ssWiPort>::iterator it = ports.begin();

        buffer[n++] = 255;
        // && n<(INTERNAL_BUFFER_SIZE-sizeof(PortID)-sizeof(PortValue)-1)
        for (; it!=ports.end(); it++) {
            if ((*it).second.isModified()) {
                buffer[n++] = (*it).first;
                PortValue tmp = (*it).second.getTXValue();
                for (int i=0; i<sizeof(PortValue); i++) {
                    buffer[n++] = tmp & 0x00ff;
                    tmp = tmp>>8;
                }
            }
        }
        //buffer[n++] = '\r';
        if (n>1) {
            mutexChannel.lock();
            channel->write(buffer, n);
            mutexChannel.unlock();
        }
        //printf("Totale byte: %d\n\r", n);
        //for (int i=0; i<n; i++)
        //    printf("%d ", buffer[i]);
        //printf("\n\r");
        Thread::wait(200);
    }
}

void threadReceiver (void const* arg)
{
    char buffer[INTERNAL_BUFFER_SIZE];
    while(true) {
        mutexChannel.lock();
        int n = channel->read(buffer);
        //printf("Byte letti: %d\n\r", n);
        //for (int i=0; i<n; i++)
        //    printf("%d ", buffer[i]);
        //printf("\n\r");
        mutexChannel.unlock();

        int i = 0;
        for (; buffer[i]!=255 && i<n; i++);
        i++;

        for (; i<n;) {
            PortID port = buffer[i++];
            PortValue value = 0;
            for (int j=sizeof(PortValue)-1; j>=0; j--) {
                value = value<<8;
                value += buffer[i+j];
            }
            i += sizeof(PortValue);
            if (ports.find(port)!=ports.end())
                ports[port].setRXValue(value);
        }
        Thread::wait(100);
    }
}
*/