#ifndef __SHARED_SLOTTED_WIRELESS_HPP__
#define __SHARED_SLOTTED_WIRELESS_HPP__

#include "ssWiTypes.hpp"
#include "ssWiChannel.hpp"
#include "ssWiPort.hpp"
#include "ssWiSocket.hpp"

#include "rtos.h"

#include <map>



#define N_PORTS 256



class ssWi
{

    ssWiChannel* channel;
    Mutex mutexChannel;

    Thread* sender;
    Thread* receiver;

    int msTXSleep;
    int msRXSleep;

    std::map<int, ssWiPort> ports;

    friend void threadReceiver (void const* arg);
    friend void threadSender (void const* arg);

    bool setPort (PortID port);
    bool isActive (PortID port) {
        return ports.find(port)!=ports.end();
    }
    bool unsetPort (PortID port);

    void readFromChannel (char* msg, int& len);
    void writeOnChannel (char* msg, int len);

    int getTXSleep () {
        return msTXSleep;
    }
    int getRXSleep () {
        return msRXSleep;
    }

public:

    ssWi (ssWiChannel* channel, int rateTX=10, int rateRX=20);
    ~ssWi ();

    ssWiSocket* createSocket (PortID port);



};

#endif //__SHARED_SLOTTED_WIRELESS_HPP__
