#include "ssWi.hpp"

#include "mbed.h"
#include "rtos.h"


void threadSender (void const* arg);
void threadReceiver (void const* arg);


ssWi::ssWi (ssWiChannel* c, int rateTX, int rateRX)
{
    msTXSleep = 1000/rateTX;
    msRXSleep = 1000/rateRX;
    mutexChannel.lock();
    channel = c;
    sender = new Thread(threadSender, this);
    receiver = new Thread(threadReceiver, this);
    mutexChannel.unlock();
}

ssWi::~ssWi ()
{
    delete sender;
    delete receiver;
}

ssWiSocket* ssWi::createSocket (PortID port)
{
    setPort(port);
    return new ssWiSocket(&ports[port]);
}

bool ssWi::setPort (PortID port)
{
    if (isActive(port))
        return false;
    ports[port];
    return true;
}

bool ssWi::unsetPort (PortID port)
{
    if (!isActive(port))
        return false;
    ports.erase(port);
    return true;
}

void ssWi::readFromChannel (char* msg, int& len)
{
    mutexChannel.lock();
    len = channel->read(msg);
    mutexChannel.unlock();
}

void ssWi::writeOnChannel (char* msg, int len)
{
    mutexChannel.lock();
    channel->write(msg, len);
    mutexChannel.unlock();
}

#define INTERNAL_BUFFER_SIZE 100

void threadSender (void const* arg)
{
    ssWi* s = (ssWi*)arg;
    char buffer[INTERNAL_BUFFER_SIZE];
    while(true) {
        int n = 0;
        std::map<int, ssWiPort>::iterator it = s->ports.begin();

        buffer[n++] = 255;
        for (; it!=s->ports.end(); it++) {
            if ((*it).second.isModified()) {
                buffer[n++] = (*it).first;
                PortValue tmp = (*it).second.getTXValue();
                for (int i=0; i<sizeof(PortValue); i++) {
                    buffer[n++] = tmp & 0x00ff;
                    tmp = tmp>>8;
                }
            }
        }
        if (n>1)
            s->writeOnChannel(buffer, n);
        Thread::wait(s->getTXSleep());
    }
}

void threadReceiver (void const* arg)
{
    ssWi* s = (ssWi*)arg;
    char buffer[INTERNAL_BUFFER_SIZE];
    while(true) {
        int n;
        s->readFromChannel(buffer, n);

        int i = 0;
        for (; buffer[i]!=255 && i<n; i++);
        i++;

        for (; i<n;) {
            PortID port = buffer[i++];
            PortValue value = 0;
            for (int j=sizeof(PortValue)-1; j>=0; j--) {
                value = value<<8;
                value += buffer[i+j];
            }
            i += sizeof(PortValue);
            if (s->ports.find(port)!=s->ports.end())
                s->ports[port].setRXValue(value);
        }
        Thread::wait(s->getRXSleep());
    }
}
