#ifndef __SHARED_SLOTTED_WIRELESS_HPP__
#define __SHARED_SLOTTED_WIRELESS_HPP__

#include "ssWiTypes.hpp"

/** \brief number of provided ports
 *
 */
#define N_PORTS 256

class ssWiChannel;

/** \brief Initialize the ssWi protocol
 *
 * It is not possible to have two instances of this protocol at the same time. 
 *
 * \param c channel to be used for sending/receving data
 * \param rateTX transmission rate
 * \param rateRX receiving rate
 * \return true if the network has been correctly initialized, false otherwise
 */
bool ssWi_init (ssWiChannel* c, int rateTX, int rateRX);

void ssWi_stop ();

bool ssWi_isActive (PortID port);

bool ssWi_setPort (PortID port);

bool ssWi_unsetPort (PortID port);


#endif //__SHARED_SLOTTED_WIRELESS_HPP__
