#include "ssWiChannel.hpp"
#include "ssWiPort.hpp"
#include "ssWi.hpp"

#include "mbed.h"
#include "rtos.h"

#include <map>


#define INTERNAL_BUFFER_SIZE 100


Thread* sender;
Thread* receiver;

ssWiChannel* channel = NULL;
Mutex mutexChannel;

std::map<int, ssWiPort> ports;

int TXRate;
int RXRate;


void threadSender (void const* arg);
void threadReceiver (void const* arg);


bool ssWi_init (ssWiChannel* c, int rateTX, int rateRX)
{
    if (channel!=NULL)
        return false;
    TXRate = 1000.0/rateTX;
    RXRate = 1000.0/rateRX;
    mutexChannel.lock();
    channel = c;
    sender = new Thread(threadSender);
    receiver = new Thread(threadReceiver);
    mutexChannel.unlock();
    return true;
}

bool ssWi_isActive (PortID port)
{
    return channel!=NULL && ports.find(port)!=ports.end();
}

bool ssWi_setPort (PortID port)
{
    if (channel==NULL)
        return false;
    ports[port];
    return true;
}

bool ssWi_unsetPort (PortID port)
{
    if (!ssWi_isActive(port))
        return false;
    ports.erase(port);
    return true;
}

void threadSender (void const* arg)
{
    char buffer[INTERNAL_BUFFER_SIZE];
    while(true) {
        int n = 0;
        buffer[n++] = 255;
        std::map<int, ssWiPort>::iterator it = ports.begin();
        for (; it!=ports.end(); it++) {
            if ((*it).second.isModified()) {
                buffer[n++] = (*it).first;
                PortValue tmp = (*it).second.getTXValue();
                memcpy(&buffer[n], &tmp, sizeof(PortValue));
                n += sizeof(PortValue);
                //for (int i=0; i<sizeof(PortValue); i++) {
                //    buffer[n++] = tmp & 0x00ff;
                //    tmp = tmp>>8;
                //}
            }
        }
        if (n>1) {
            mutexChannel.lock();
            channel->write(buffer, n);
            mutexChannel.unlock();
/*
            printf("W: ");
            for(int k=0; k<n; k++)
                printf("%d ", buffer[k]);
            printf("\n\r");
*/
        }
        Thread::wait(TXRate);
    }
}

void threadReceiver (void const* arg)
{
    char buffer[INTERNAL_BUFFER_SIZE];
    while(true) {
        mutexChannel.lock();
        int n = channel->read(buffer);
        mutexChannel.unlock();
/*
        if (n>0) {
            printf("R: ");
            for(int k=0; k<n; k++)
                printf("%d ", buffer[k]);
            printf("\n\r");
        }
*/
        int i = 0;
        for (; buffer[i]!=255 && i<n; i++);
        i++;

        for (; i<n;) {
            PortID port = buffer[i++];
            PortValue value = 0;
            memcpy(&value, &buffer[i], sizeof(PortValue));
/*
            for (int j=sizeof(PortValue)-1; j>=0; j--) {
                value = value<<8;
                value += buffer[i+j];
            }
*/
            i += sizeof(PortValue);
            if (ports.find(port)!=ports.end())
                ports[port].setRXValue(value);
        }
        Thread::wait(RXRate);
    }
}
