#ifndef __JOYSTICK_HPP__
#define __JOYSTICK_HPP__

#include <limits>

#include "mbed.h"
#include "rtos.h"

#define JOYSTICK_SX_X 1
#define JOYSTICK_SX_Y 0
#define JOYSTICK_DX_X 2
#define JOYSTICK_DX_Y 3

class Joystick
{

    AnalogIn* channels[4];
    float values[4];
    Mutex mutexes[4];

    struct RangeJoystichChannel {
        float maxV;
        float minV;
        float center;
        RangeJoystichChannel () {
            maxV = std::numeric_limits<float>::min();
            minV = std::numeric_limits<float>::max();
            center = 0.0;
        }
    };

    RangeJoystichChannel ranges[4];

    void update(int channel);

public:

    Joystick (PinName pinSX_X, PinName pinSX_Y, PinName pinDX_X, PinName pinDX_Y) {
        channels[JOYSTICK_SX_X] = new AnalogIn(pinSX_X);
        channels[JOYSTICK_SX_Y] = new AnalogIn(pinSX_Y);
        channels[JOYSTICK_DX_X] = new AnalogIn(pinDX_X);
        channels[JOYSTICK_DX_Y] = new AnalogIn(pinDX_Y);
    }

    void tuneCentring (int nOfSamples, int channel);
    void tuneChannel (int nOfSamples, int channel);
    
    void update();

    float read(int channel);

    ~Joystick () {
        delete channels[JOYSTICK_SX_X];
        delete channels[JOYSTICK_SX_Y];
        delete channels[JOYSTICK_DX_X];
        delete channels[JOYSTICK_DX_Y];
    }
};


#endif //__JOYSTICK_HPP__
