#include "mbed.h"
#include "rtos.h"

#include "xbee.hpp"
#include "ssWiSocket.hpp"
#include "joystick.hpp"


#define UPDATING_PERIOD_MS 200

#define PORT_MOTOR 20
#define PORT_SERVO 30
#define PORT_SERVO_CAMERA_X 40
#define PORT_SERVO_CAMERA_Y 50


ssWiSocket* socket_motor;
ssWiSocket* socket_servo;
ssWiSocket* socket_camera_x;
ssWiSocket* socket_camera_y;

Joystick joystick(p15, p16, p17, p18);


void tuneJoystickChannel (PinName pinLed, int joystickChannel);
void updateFunction (const void* arg);


int main ()
{
    //Communication link connection
    XBeeModule xbee(p9, p10, 102, 14);
    xbee.setDstAddress(XBeeBroadcastAddress());
    xbee.init(5, -1);

    //Socket creation
    socket_motor = ssWiSocket::createSocket(PORT_MOTOR);
    socket_servo = ssWiSocket::createSocket(PORT_SERVO);
    socket_camera_x = ssWiSocket::createSocket(PORT_SERVO_CAMERA_X);
    socket_camera_y = ssWiSocket::createSocket(PORT_SERVO_CAMERA_Y);
    if (socket_motor==NULL || socket_servo==NULL || 
                socket_camera_x==NULL || socket_camera_y==NULL)
        printf("Error: socket error\n\r");

    //Joystick centering
    joystick.tuneCentring(20, JOYSTICK_SX_X);
    joystick.tuneCentring(20, JOYSTICK_SX_Y);
    joystick.tuneCentring(20, JOYSTICK_DX_X);
    joystick.tuneCentring(20, JOYSTICK_DX_Y);

    //Joystick tuning
    {
        //tuneJoystickChannel(LED1, JOYSTICK_SX_X);
        DigitalOut led1(LED1);
        led1 = 1;
        joystick.tuneChannel(100, JOYSTICK_SX_X);
        led1 = 0;
    }
    {
        //tuneJoystickChannel(LED2, JOYSTICK_SX_Y);
        DigitalOut led2(LED2);
        led2 = 1;
        joystick.tuneChannel(100, JOYSTICK_SX_Y);
        led2 = 0;
    }
    {
        //tuneJoystickChannel(LED3, JOYSTICK_DX_X);
        DigitalOut led3(LED3);
        led3 = 1;
        joystick.tuneChannel(100, JOYSTICK_DX_X);
        led3 = 0;
    }
    {
        //tuneJoystickChannel(LED4, JOYSTICK_DX_Y);
        DigitalOut led4(LED4);
        led4 = 1;
        joystick.tuneChannel(100, JOYSTICK_DX_Y);
        led4 = 0;
    }
    //Timer setting
    RtosTimer timer (updateFunction, osTimerPeriodic, NULL);
    timer.start(200);

    //Infinite wait
    Thread::wait(osWaitForever);
}


void updateFunction (const void* arg)
{
//    while(1) {
    joystick.update();
    socket_motor->write(-joystick.read(JOYSTICK_SX_Y)*1000.0);
    socket_servo->write(joystick.read(JOYSTICK_SX_X)*1000.0);
    socket_camera_x->write(joystick.read(JOYSTICK_DX_X)*1000.0);
    socket_camera_y->write(joystick.read(JOYSTICK_DX_Y)*1000.0);
//    printf("%f %f %f %f\n\r", joystick.read(JOYSTICK_SX_X), joystick.read(JOYSTICK_SX_Y), joystick.read(JOYSTICK_DX_X), joystick.read(JOYSTICK_DX_Y));
//        Thread::wait(UPDATING_PERIOD_MS);
//    }
}


void tuneJoystickChannel (PinName pinLed, int joystickChannel)
{
    DigitalOut led(pinLed);
    led = 1;
    joystick.tuneChannel(100, joystickChannel);
    led = 0;
}
