#include "joystick.hpp"


void Joystick::tuneChannel (int nOfSamples, int channel)
{
    if (channel<0 || channel>3)
        return;
    ranges[channel].maxV = std::numeric_limits<float>::min();
    ranges[channel].minV = std::numeric_limits<float>::max();
    for (int i=0; i<nOfSamples; i++) {
        float val = channels[channel]->read();
        if (val>ranges[channel].maxV)
            ranges[channel].maxV = val;
        else if (val<ranges[channel].minV)
            ranges[channel].minV = val;
        wait(0.1);
    }
}

void Joystick::tuneCentring (int nOfSamples, int channel)
{
    if (channel<0 || channel>3)
        return;
    ranges[channel].center = 0.0;
    for (int i=0; i<nOfSamples; i++) {
        float val = channels[channel]->read();
        ranges[channel].center += val;
        wait(0.1);
    }
    ranges[channel].center /= nOfSamples;
}



float Joystick::read(int channel)
{
    if (channel<0 || channel>3)
        return std::numeric_limits<float>::min();
    mutexes[channel].lock();
    float val = values[channel];
    mutexes[channel].unlock();
    return val;
}


void Joystick::update (int channel)
{
    mutexes[channel].lock();
    float val = channels[channel]->read();
    mutexes[channel].unlock();
    if (val>ranges[channel].center)
        values[channel] = -(val-ranges[channel].center)/
                (ranges[channel].maxV-ranges[channel].center);
    else
        values[channel] = (ranges[channel].center-val)/
                (ranges[channel].center-ranges[channel].minV);
}

void Joystick::update ()
{
    update(JOYSTICK_SX_X);
    update(JOYSTICK_SX_Y);
    update(JOYSTICK_DX_X);
    update(JOYSTICK_DX_Y);
}
