#include "servo.hpp"


Servo::Servo (PinName pwm, float min, float max, float center): _pwm(pwm)
{
    _pwm.period(0.02);
    _min = min;
    _max = max;
    _center = center;
    *this = 0.5;
}

Servo &Servo::operator= (float angle)
{
    if (angle>1.0)
        angle = 1.0;
    else
        if (angle<-1.0)
            angle = -1.0;
    _pwm.pulsewidth(_center+((_max-_min)*(angle/2.0)));
    return *this;
}

Servo::operator float()
{
    return _pwm.read();
}
