#include "mbed.h"
#include "rtos.h"

#include "xbee.hpp"
#include "ssWiSocket.hpp"
#include "car.hpp"


#define PORT_MOTOR 20
#define PORT_SERVO 30
#define PORT_SERVO_CAMERA_X 40
#define PORT_SERVO_CAMERA_Y 50

#define UPDATING_FUNCTION_MS 200


ssWiSocket* socket_motor;
ssWiSocket* socket_servo;
ssWiSocket* socket_camera_x;
ssWiSocket* socket_camera_y;

Car car(p23, p24, p25, p26);


void udateFunction (const void* arg);


int main()
{
    //Communication link connection
    XBeeModule xbee(p9, p10, 102, 14);
    xbee.setDstAddress(XBeeBroadcastAddress());
    xbee.init(-1, 5);

    //Socket creation
    socket_motor = ssWiSocket::createSocket(PORT_MOTOR);
    socket_servo = ssWiSocket::createSocket(PORT_SERVO);
    socket_camera_x = ssWiSocket::createSocket(PORT_SERVO_CAMERA_X);
    socket_camera_y = ssWiSocket::createSocket(PORT_SERVO_CAMERA_Y);
    if (socket_motor==NULL || socket_servo==NULL ||
                    socket_camera_x==NULL || socket_camera_y==NULL)
        printf("Error: sockets\n\r");

    //Timer setting
    RtosTimer timer(udateFunction, osTimerPeriodic, NULL);
    timer.start(200);

    //Infinite wait
    Thread::wait(osWaitForever);
}


void udateFunction (const void* arg)
{
    static DigitalOut led(LED1);
    static int var = 0;
//    while(1) {
    car.setSpeed((float)(socket_motor->read())/1000.0);
    car.setSteering((float)(socket_servo->read())/1000.0);
    float x = (float)socket_camera_x->read()/1000.0;
    float y = (float)socket_camera_y->read()/1000.0;
    car.setCamera(x, y);
    led = var>=10?1:0;
    var = var>=20?0:var+1;
//        Thread::wait(UPDATING_FUNCTION_MS);
//    }
}
