/**********************************************************
 * CONFIGURATION: before starting, configure the reader
 **********************************************************/

//define the number of channels to use:
// -) 1 channel: p20
// -) 2 channels: p19 and p20
#define NCHANNELS 1
//#define nChannels 1

//number of samples to read before printing their average
#define NSAMPLES 2500

//number of samplng operation after an user trigger
//(total samples: NSAMPLES*NSAMPLING)
#define NSAMPLING 50

//read NSAMPLES values when the pin p9 is high
#define PIN_TRIGGERED 2

//the sampling is run only when the user presses the character 's'
//the operation lasts for NSAMPLING iterations
#define USER_TRIGGERED 1

//read all the time
#define ENDLESS_READ 0

#define ACQ_TYPE USER_TRIGGERED


/**********************************************************
 * CONFIGURATION CHECK
 **********************************************************/
#if !defined(NCHANNELS) || (NCHANNELS!=1 && NCHANNELS!=2)
#error "The number of channels is wrong"
#endif

#if !defined(ACQ_TYPE) || (ACQ_TYPE!=ENDLESS_READ && \
         ACQ_TYPE!=PIN_TRIGGERED && ACQ_TYPE!=USER_TRIGGERED)
#error "Acquisition type not detected or not valid"       
#endif

#if ACQ_TYPE==USER_TRIGGERED && !defined(NSAMPLING)
#error "Define a number of samplings after the user trigger"
#endif


/**********************************************************
 * CODE
 **********************************************************/
 
#include "mbed.h"

AnalogIn ain_1(p20);
#if NCHANNELS==2
AnalogIn ain_2(p19);
#endif

#if ACQ_TYPE==PIN_TRIGGERED
DigitalIn firer (p9);
#endif

#define V_max 3.3

int main()
{
    double vref_1 = 0.0;
#if NCHANNELS==2
    double vref_2 = 0.0;
#endif
    
    //acquiring v_ref
    for (int i=0; i<NSAMPLES; i++) {
        vref_1 += ain_1;
#if NCHANNELS==2
        vref_2 += ain_2;
#endif
    }
    vref_1 /= NSAMPLES;
    printf("Vref 1: %f\n\r", vref_1);
#if NCHANNELS==2
    vref_2 /= NSAMPLES;
    printf("Vref 2: %f\n\r", vref_2);
#endif

    //main loop
    while(true) {
        //start condition
#if ACQ_TYPE==USER_TRIGGERED
        printf("press \'s\' to start\n\r");
        int c;
        do {
            c = getchar();
        } while (c!='s');
        for (int i=0; i<NSAMPLING; i++) {
#elif ACQ_TYPE==PIN_TRIGGERED
        while(firer==0);
#elif ACQ_TYPE==ENDLESS_READ
#else
//already signaled
//#error "Acquisition type not detected"
#endif

            //acquisition
            double sum_1 = 0.0;
#if NCHANNELS==2
            double sum_2 = 0.0;
#endif
            for (int samples = 0; samples<NSAMPLES; samples++) {
                sum_1 += ain_1;
#if NCHANNELS==2
                sum_2 += ain_2;
#endif
            }
            sum_1 /= NSAMPLES;
            sum_1 = (sum_1-vref_1)*V_max/0.185;
#if NCHANNELS==2
            sum_2 /= NSAMPLES;
            sum_2 = (sum_2-vref_2)*V_max/0.185;
            printf("%f\n\r", sum_1+sum_2);
#else
            printf("%f\n\r", sum_1);
#endif

            //final condition
#if ACQ_TYPE==USER_TRIGGERED
        }
#elif ACQ_TYPE==PIN_TRIGGERED
#elif ACQ_TYPE==ENDLESS_READ
#else
#endif
    }
}
