#include "mbed.h"
#include "dc_motor.hpp"

int main ()
{
    AnalogIn vert(p20);
    AnalogIn horz(p19);
    DC_motor m_sx(p21, p22);
    DC_motor m_dx(p23, p24);

    while(1) {
        wait(0.2);
        float v = vert.read();
        float h = horz.read();
        float speed_sx = (v-0.5)*2.0;
        if (h>0.5)
            speed_sx *= (1.0-(h-0.5)*2.0);
        float speed_dx = (v-0.5)*2.0;
        if (h<0.5)
            speed_dx *= ((h+0.5)*2.0-1.0);
        m_sx.speed(speed_sx);
        m_dx.speed(speed_dx);
//        printf("VERT(%f), HORZ(%f), sx(%f), dx(%f)\n\r",
//                vert.read(), horz.read(), speed_sx, speed_dx);
    }
}
