#ifndef __CAR_CONFIG_H__
#define __CAR_CONFIG_H__

#include "common_types.h"

/*********************
 * THREADS
 *********************/ 

#define CLOCK_THREAD_PERIOD     1000  //milliseconds
#define ENGINE_THREAD_PERIOD    250   //milliseconds
#define BODY_THREAD_PERIOD      500   //milliseconds
#define DIAG_THREAD_PERIOD      500   //milliseconds
#define CAN_THREAD_PERIOD       100   //milliseconds

/*********************
 * CAN MSGs
 *********************/

//#define NET_TX_CMD_BODY
#define NET_TX_STS_BODY
//#define NET_TX_CMD_ENGINE
//#define NET_TX_CMD_TIME
//#define NET_TX_CMD_DIAG
#define NET_TX_STS_DIAG
//#define NET_TX_CMD_CAMERA
#define NET_RX_CMD_BODY
//#define NET_RX_STS_BODY
#define NET_RX_CMD_ENGINE
#define NET_RX_CMD_TIME
#define NET_RX_CMD_DIAG
//#define NET_RX_STS_DIAG
//#define NET_RX_CMD_CAMERA

/*********************
 * HW CONFIG
 *********************/

//CAN
#define HW_CAN_TX                    p9
#define HW_CAN_RX                    p10

//LED
#define HW_ALIVE_LED                 LED1

//BODY
#define HW_REAR_RIGHT_EYE            p19
#define HW_REAR_LEFT_EYE             p20
#define HW_FRONT_EYE_RX              p28
#define HW_FRONT_EYE_TX              p27
#define HW_HIT_FRONT                 p14
#define HW_HIT_REAR                  p15
#define HW_HIT_LEFT                  p16
#define HW_HIT_RIGHT                 p17
#define HW_FRONT_EYE_ADDR            0xE0
#define HW_FRONT_EYE_DEFAULT_ADDR    0xF2

//ENGINE
#define HW_STEERING_SERVO            p21
#define HW_ENGINE_ENABLER            p22
#define HW_ENGINE_DIR_1              p23
#define HW_ENGINE_DIR_2              p24
#define HW_ENGINE_PERIOD             (0.100)
#define HW_SERVO_RANGE_INIT          (0.0005)
#define HW_SERVO_ANGLE_INIT          (45.0)

#endif //__CAR_CONFIG_H__
