in main.cpp

/*
    printf("INIT EEPROM\r\n");
    init_eeprom();
*/

/****************** EEPROM ******************/
/*
eeprom_t eeprom(p7, p5, p6, p9, PAGENUMBER, PAGESIZE);

t_eeprom_data eeprom_data[] = {
    //SIZE,   ADDR
    {    2,      0}, //SOFTWARE VERSION
    {    2,      2}, //DATA VERSION
    {    4,      4}, //NUMBER OF STARTS
    {    4,     20}, //T_MISSING
    {    4,     40}, //ENGINE_LAST_MISSING
    {    4,     44}  //BODY_LAST_MISSING
};

void init_eeprom ()
{
    eeprom.init(eeprom_data, sizeof(eeprom_data)/sizeof(t_eeprom_data));

    uint16 sw = 0;
    uint16 dd = 0;
    uint32 num = 0;
    if ((eeprom.read(EEPROM_DATA_SW_VERS, (uint8*)(&sw)) != 2) ||
        (eeprom.read(EEPROM_DATA_DD_VERS, (uint8*)(&dd)) != 2) ||
        (sw != SW_VERSION) || (dd != DD_VERSION))
    {
        //error
        eeprom.reset();
        sw = SW_VERSION;
        eeprom.write(EEPROM_DATA_SW_VERS, (uint8*)(&sw));
        dd = DD_VERSION;
        eeprom.write(EEPROM_DATA_DD_VERS, (uint8*)(&dd));
    }

    if (eeprom.read(EEPROM_DATA_NSTARTS, (uint8*)(&num)) != 4)
        num = 0xffffffff;
    num++;
    eeprom.write(EEPROM_DATA_NSTARTS, (unsigned char*)(&num));
}
*/

in eeprom.hpp

#ifndef __EEPROM_H__
#define __EEPROM_H__  
/*
#include "common_types.h"

#include "Ser25lcxxx.h"

#define EEPROM_ENTRY_NOT_VALID      ((int8)(-1))
#define EEPROM_ERR_READ             ((int8)(-2))
#define EEPROM_ERR_WRITE            ((int8)(-3))

typedef struct {
    uint8  size;            // number of bytes
    uint32 addr;            // eeprom address
} t_eeprom_data;

class eeprom_t
{

    t_eeprom_data *eeprom_data; // configuration table of the eeprom

    Ser25LCxxx memory; // memory
    
    uint32 n; // total number of stored items
    uint32 max_pages; // total number of pages in eeprom
    uint32 page_size; // size of each page
    
    uint32 n_used_pages; // total number of used pages

public:

    eeprom_t (PinName sck, PinName si, PinName so, PinName enable,
              int pagenumber, int pagesize):
                    memory(sck, si, so, enable, pagenumber, pagesize)
    {
        max_pages = pagenumber;
        page_size = pagesize;
    }

    bool init (t_eeprom_data *data, unsigned int num);

    bool reset();

    int8 read (uint32 id, uint8* dst);

    int8 write (uint32 id, const uint8* src);
    
};
*/
#endif //__EEPROM_H__

in eeprom.cpp

/*
#include "eeprom.hpp"

bool eeprom_t::init (t_eeprom_data *data, unsigned int num)
{
    if (!memory.isFullyWritable())
        memory.setFullyWritable();

    n = num;
    eeprom_data = data;
    uint32 max_addr = 0;

    for (int i = 0; i < n; i++) {
//        unsigned int buffer = 0;
//        unsigned int nread = memory.read(eeprom_data[i].addr,
//                                         eeprom_data[i].size,
//                                         (unsigned char*)(&buffer));
//        if (nread == eeprom_data[i].size)
//            local_values[i] = buffer;
        if (eeprom_data[i].addr > max_addr)
            max_addr = eeprom_data[i].addr + eeprom_data[i].size;
    }

    n_used_pages = max_addr / page_size + 1;

    return true;
}

bool eeprom_t::reset ()
{
   for (int i = 0; i <= n_used_pages; i++) {
        __disable_irq();
        memory.clearPage(i);
        __enable_irq();
    }

    return true;
}

int8 eeprom_t::read (uint32 id, uint8* dst)
{
    if (id >= n)
        return EEPROM_ENTRY_NOT_VALID;

//critical section
    __disable_irq();
    int num = memory.read(eeprom_data[id].addr, eeprom_data[id].size, dst);
    __enable_irq();
//critical section

    if (num == eeprom_data[id].size)
        return num;

    return EEPROM_ERR_READ;
}

int8 eeprom_t::write (uint32 id, const uint8* src)
{
    if (id >= n)
        return EEPROM_ENTRY_NOT_VALID;

    //critical section
    __disable_irq();
    int num = memory.write(eeprom_data[id].addr, eeprom_data[id].size, src);
    __enable_irq();
    //critical section

    if (num != eeprom_data[id].size)
        return EEPROM_ERR_WRITE;

    return num;
}
*/
