#include "mbed.h"
 
#include "net.hpp"
 
/*
Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9, p10);
CAN can2(p30, p29);
char counter = 0;

void send() {
    printf("send()\r\n");
    if(can1.write(CANMessage(1337, &counter, 1))) {
        printf("wloop()\r\n");
        counter++;
        printf("Message sent: %d\r\n", counter);
    } 
    led1 = !led1;
}
*/


Ticker ticker;

DigitalOut led_body(LED1);
DigitalOut led_engine(LED2);
DigitalOut led_time(LED3);
DigitalOut led_driver(LED4);

CAN can(p9, p10);

can_cmd_body_t can_cmd_body;
can_cmd_engine_t can_cmd_engine;
can_cmd_driver_t can_cmd_driver;
can_cmd_time_t can_cmd_time;

int counter = 0;
int echo = 0;

#define BODY_       4
#define ENGINE_     2
#define DRIVER_     5
#define TIME_       11

void send() {
    //printf("send()\r\n");

    static int body_n_sent = 0;
    static int engine_n_sent = 0;
    static int driver_n_sent = 0;
    static int time_n_sent = 0;

    counter++;

    if ((counter%BODY_)==0) {
        can_cmd_body.payload.msg.light_r = (body_n_sent&0x0001)==0x0001;
        can_cmd_body.payload.msg.light_l = (body_n_sent&0x0002)==0x0002;
        can_cmd_body.payload.msg.light_c = (body_n_sent&0x0004)==0x0004;
        if(can.write(CANMessage(CAN_CMD_BODY_ID, (char*)(can_cmd_body.payload.buf), 4)))
            led_body = !led_body;//printf("BODY OK\r\n");
        else
            printf("BODY NOT OK\r\n");
        
        body_n_sent++;
    }

    if ((counter%ENGINE_)==0) {
        can_cmd_engine.payload.msg.steering = engine_n_sent;
        can_cmd_engine.payload.msg.power = engine_n_sent+2;
        can_cmd_engine.payload.msg.direction = engine_n_sent%2;
        can_cmd_engine.payload.msg.breaking = (engine_n_sent%2)?0:1;
        if(can.write(CANMessage(CAN_CMD_ENGINE_ID, (char*)(can_cmd_engine.payload.buf), 4)))
            led_engine = !led_engine;//printf("ENGINE OK\r\n");
        else
            printf("ENGINE NOT OK\r\n");
        
        engine_n_sent++;
    }

    if ((counter%DRIVER_)==0) {
        can_cmd_driver.payload.msg.cmd = 0x0A0A;
        echo = counter;
        can_cmd_driver.payload.msg.data = counter;
        if(can.write(CANMessage(CAN_CMD_DRIVER_ID, (char*)(can_cmd_driver.payload.buf), 8)))
            led_driver = !led_driver;//printf("DRIVER OK\r\n");
        else
            printf("DRIVER NOT OK\r\n");
        
        driver_n_sent++;
    }
    
    if ((counter%TIME_)==0) {
        can_cmd_time.payload.msg.time = time(NULL);
        if(can.write(CANMessage(CAN_CMD_TIME_ID, (char*)(can_cmd_time.payload.buf), 4)))
            led_time = !led_time;//printf("TIME OK\r\n");
        else
            printf("TIME NOT OK\r\n");

        time_n_sent++;
    }
    
}


int main() {
/*
    printf("main()\r\n");
    ticker.attach(&send, 1);
    CANMessage msg;
    while(1) {
        printf("loop()\r\n");
        if(can2.read(msg)) {
            printf("Message received: %d\r\n", msg.data[0]);
            led2 = !led2;
        } 
        wait(0.2);
    }
*/

    printf("main()\r\n");
    ticker.attach(&send, 0.5);
set_time(0);
    CANMessage msg;
    while(1) {
        if(can.read(msg)) {
            switch(msg.id) {
            case CAN_CMD_BODY_ID:
                can_sts_body_payload_t x;
                x.buf[0] = msg.data[0]; x.buf[1] = msg.data[1]; x.buf[2] = msg.data[2]; x.buf[3] = msg.data[3];
                x.buf[4] = msg.data[4]; x.buf[5] = msg.data[5]; x.buf[6] = msg.data[6]; x.buf[7] = msg.data[7];
                printf("Message received: %d %d %d %d\r\n", x.buf[0], x.msg.eye_back_l, x.msg.eye_back_r, x.msg.eye_front);
                break;
            case CAN_STS_DRIVER_ID:
                can_sts_driver_payload_t y;
                y.buf[0] = msg.data[0]; y.buf[1] = msg.data[1]; y.buf[2] = msg.data[2]; y.buf[3] = msg.data[3];
                if (y.msg.data == echo)
                    printf("ECHO %d\r\n", y.msg.data);
                else 
                    printf("NO ECHO %d\r\n", y.msg.data);
                break;
            }
        }
        wait(1.0);
    }
}
