/** Projektiranje ugradbenih računalnih sustava
* Default metoda za unipolarni steper motor
* @author: mario_meh
* @code
* #include "mbed.h"
* #include "umotor.h"
*
*
* Steper *unipolar = new Steper();    
* unipolar->u_poz.u_krenuo = 1;  // Treba biti 1(0)
* unipolar->u_poz.u_stao = 0;    // Treba biti 0(1)
* unipolar->Brzina(4000);        // < brzina = brze i krace
* unipolar->UEnable();           // Pokreni umotor 
*
* @endcode
*/
#include "mbed.h"
#include "umotor.h"

#define OKRETAJA 4000
#define STEPER_STEP 0.5

int step;
int broji;
int u_okretaja = OKRETAJA;
float za_step = STEPER_STEP;
/** Unipolarni motor radi u half-step modu */
const uint8_t u_zavojnica[8][4] = {{1,0,0,1}, {1,0,0,0}, {1,1,0,0}, {0,1,0,0}, {0,1,1,0}, {0,0,1,0}, {0,0,1,1}, {0,0,0,1}};
/** Konstruktor 
* inicijalizacija je: Steper <naziv> = new Steper;
*/
Steper::Steper() : coil1(PTC12), coil2(PTC13), coil3(PTC16), coil4(PTA13)

{
    
}

bool pbonePressed = false;
bool ready = true;

void Steper::stepper_step(int broji) 
{
    static uint8_t i = 0;
    if(u_t.read_us() > u_okretaja*za_step) {
        switch(i) {
            case 0:
                coil1 = u_zavojnica[broji][0];
                i++;
            case 1:
                coil2 = u_zavojnica[broji][1];
                i++;
            case 2:
                coil3 = u_zavojnica[broji][2];
                i++;
            case 3:
                coil4 = u_zavojnica[broji][3];
                i++;
            default:
                i = 0;
        }
        u_t.reset();
    }    
} 

void Steper::timer_isr() {
    step++;
    if(step <= u_okretaja) {
        u_motor();
    }
}

void Steper::u_motor() {
    if(u_poz.u_krenuo == 1) {
        stepper_step(broji++);
        if(broji == 8) {
            broji = 0;
        }
    }
    if(u_poz.u_stao) {
        u_ticker.detach();
    }
}

int Steper::Brzina(int okretaja) {
    if(okretaja < OKRETAJA) {
        u_okretaja = okretaja;
        za_step = (float)((STEPER_STEP*1000)/OKRETAJA);
    }
    if(okretaja >= OKRETAJA) {
        u_okretaja = okretaja;
        za_step = (float)((STEPER_STEP*1000)/OKRETAJA);
    }
    return u_okretaja;
}

void Steper::UEnable() {
    u_t.start();
    u_ticker.attach_us(this, &Steper::timer_isr, u_okretaja);
}