#include "mbed.h"
#include "jsmn.h"
#include "Motor.h"
#include <string>
#include <cctype>

#define       MAXTOKEN       64

const char *jsmn_type_str[] = {
  "PRIMITIVE",
  "OBJECT",
  "ARRAY",
  "STRING"
};

/*
typedef struct {
    int kreirao;
    char   kod;
    char   mcu;
    char  model;
    char extra;    
}SER_DATA;*/

Serial pc(USBTX, USBRX);
//Motor sg90(p23, p6, p5); // pwm, fwd, rev
Serial esp(p28, p27); // tx, rx
DigitalOut reset(p26);
DigitalOut led1(LED1);
DigitalOut led4(LED4);
Timer t;

//==================
DigitalOut _a1(p6);
DigitalOut _a2(p5);
DigitalOut _en(p23);

int  count,ended,timeout;
char buf[1024];
char kreirao[25];
char kod[25];
char mcu[25];
char model[25];
char extra[25];
int pos;

void getreply();
void ser_kreirao(char* inBuf, int start, int end);
void ser_kod(char* inBuf, int start, int end);
void ser_mcu(char* inBuf, int start, int end);
void ser_model(char* inBuf, int start, int end);
void ser_extra(char* inBuf, int start, int end);

int main() {
    
    pc.printf("\n ESP 01 - jsmn \r\n");
    
    // jsmn var
    const char *js;            // Pointer to json string
    int         r;             // Number of token parsed
    jsmn_parser p;             // jsmn parser
    jsmntok_t   t[MAXTOKEN];   // Parsed token
    
    //=================================
    reset = 0;
    pc.baud(9600);
    wait(1);
    reset = 1;
    //timeout = 2;
    getreply();
    
    while(1) {
        pc.printf("\r\n");
        pc.printf("\n Počinjem preuzimati - wifi \r\n");
        esp.baud(9600);
        getreply();
        timeout=1;
        
        //==============================
        jsmn_init(&p);
        r = jsmn_parse(&p, buf, strlen(buf), t, MAXTOKEN);
        pc.printf("Parsed %d tokens\n", r);
        pc.printf("            TYPE       START   END  SIZE PAR\n");
        pc.printf("           ----------  -----  ----  ---- ---\n");
        char        ch;
        jsmntok_t   at;            // A token for general use
        //===============================        
        for (int i = 0; i < r; i++){
            at = t[i];
            pc.printf("Token %2d = %-10.10s (%4d - %4d, %3d, %2d) ",
                   i, jsmn_type_str[at.type],
                   at.start, at.end,
                   at.size, at.parent);
        
            switch (i){
                  case 3:
                    ser_kreirao(buf, at.start, at.end);
                    pc.printf("\n");
                    break;
                  
                  case 5:
                    ser_kod(buf, at.start, at.end);
                    pc.printf("\n");
                    break;
                
                  case 7:
                    ser_mcu(buf, at.start, at.end);
                    pc.printf("\n");
                    break;
                    
                  case 9:
                    ser_model(buf, at.start, at.end);
                    pc.printf("\n");
                    break;
                
                  case 11:
                    ser_extra(buf, at.start, at.end);
                    pc.printf("\n");
                    break;
                  
                  default:
                    pc.printf("\n");
                    break;     
            }
        }
        
        //====================================
        pc.printf("\n");
        pc.printf("Kreirao: %s\n", kreirao);
        pc.printf("Kod: %s\n", kod);
        pc.printf("Mcu: %s\n", mcu);
        pc.printf("Model: %s\n", model);
        pc.printf("Extra: %s\n", extra);
        pc.printf("\n");
        pc.printf("ESP Json - Django linija pogona\n");
        pc.printf(buf);
        pc.printf("\n");
        //wait(2);
        if(strcmp(extra, "lijevo") == 0){
            pc.printf("Lijevo");
            //=====================
            //sg90.speed(0);
            //for (float s= -1.0; s < 0 ; s += 0.01) {
            //   sg90.speed(s); 
            //   wait(0.1);
            //}
            //=====================
            _en = 1;
            _a1 = 0;
            _a2 = 1;
            led4 = !led4;
            memset(&extra[0], 0, 25);
        } 
        if(strcmp(extra, "desno") == 0){
            pc.printf("Desno");
            //=====================
            //sg90.speed(0);
            //for (float s= 0; s < 1.0 ; s += 0.01) {
            //   sg90.speed(s); 
            //   wait(0.1);
            //}
            //=====================
            _en = 1;
            _a1 = 1;
            _a2 = 0;
            led4 = !led4;
            memset(&extra[0], 0, 25);
        }
        if(strcmp(extra, "brze") == 0){
            pc.printf("Brze");
            //=====================
            //brzina = brzina + 0.1;
            //sg90.speed(brzina);
            led4 = !led4;
            memset(&extra[0], 0, 25);
        }
        if(strcmp(extra, "sporije") == 0){
            pc.printf("Sporije\n");
            //=====================
            //brzina = brzina - 0.1;
            //sg90.speed(brzina);
            led4 = !led4;
            memset(&extra[0], 0, 25);
        }
        if(strcmp(extra, "stop") == 0){
            pc.printf("Stop");
            //=====================
            //brzina = 0;
            //sg90.speed(brzina);
            _en = 0;
            led4 = !led4;
            memset(&extra[0], 0, 25);
        }
        if(strcmp(extra, "pauziraj") == 0){
            pc.printf("Pauziraj");
            //=====================
            //brzina = 0;
            //sg90.speed(brzina);
            _en = 0;
            led4 = !led4;
            memset(&extra[0], 0, 25);
        }
    }
}

void getreply() {
    memset(buf, '\0', sizeof(buf));
    t.start();
    ended=0;
    count=0;

    while(!ended) {
        if(esp.readable()) {
            led1 = !led1;
            buf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}

void ser_kreirao(char* inBuf, int start, int end){
  char* data = inBuf;
  int j = 0;
  for (int i = start; i < end; i++){
    kreirao[j] = data[i];
    j++;
  }
}

void ser_kod(char* inBuf, int start, int end){
  char* data = inBuf;
  int j = 0;
  for (int i = start; i < end; i++){
    kod[j] = data[i];
    j++;
  }
}

void ser_mcu(char* inBuf, int start, int end){
  char* data = inBuf;
  int j = 0;
  for (int i = start; i < end; i++){
    mcu[j] = data[i];
    j++;
  }
}

void ser_model(char* inBuf, int start, int end){
  char* data = inBuf;
  int j = 0;
  for (int i = start; i < end; i++){
    model[j] = data[i];
    j++;
  }
}

void ser_extra(char* inBuf, int start, int end){
  char* data = inBuf;
  int j = 0;
  for (int i = start; i < end; i++){
    extra[j] = data[i];
    j++;
  }
}    